/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.execution;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DockerImageChecker {
    public final long CHECKED_IMAGE_VALID_TIME = 5L;
    private final Map<String, Date> checkedImagesMap = new HashMap<String, Date>();
    private static DockerImageChecker INSTANCE;

    public static final synchronized DockerImageChecker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DockerImageChecker();
        }
        return INSTANCE;
    }

    public boolean shouldCheckDockerImage(String dockerImage) {
        if (this.checkedImagesMap.containsKey(dockerImage)) {
            Date now = this.getNow();
            long diffMillis = now.getTime() - this.checkedImagesMap.get(dockerImage).getTime();
            if (TimeUnit.MINUTES.convert(diffMillis, TimeUnit.MILLISECONDS) < 5L) {
                return false;
            }
            this.checkedImagesMap.remove(dockerImage);
            return true;
        }
        return true;
    }

    public void storeImageTimestamp(String dockerImage) {
        this.checkedImagesMap.put(dockerImage, this.getNow());
    }

    private Date getNow() {
        return Calendar.getInstance().getTime();
    }
}

