/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core;

import java.util.LinkedList;
import java.util.List;
import org.sing_group.seda.core.SedaContextEvent;
import org.sing_group.seda.core.SedaContextListener;

public class SedaContext {
    public static final String SEDA_JAVA_PATH_PROPERTY = "seda.java.path";
    private final List<SedaContextListener> listeners = new LinkedList<SedaContextListener>();
    private List<String> selectedPaths;
    private boolean isInMemoryProcessingEnabled = true;
    private boolean charsetSupport = false;

    public void setSelectedPaths(List<String> selectedPaths) {
        this.selectedPaths = selectedPaths;
        this.fireSelectedPathsChanged();
    }

    private void fireSelectedPathsChanged() {
        SedaContextEvent event = new SedaContextEvent(SedaContextEvent.SedaContextEventType.SELECTED_PATHS_CHANGED);
        this.listeners.forEach(listener -> listener.contextChanged(event));
    }

    public List<String> getSelectedPaths() {
        return this.selectedPaths;
    }

    public boolean isInMemoryProcessingEnabled() {
        return this.isInMemoryProcessingEnabled;
    }

    public void setInMemoryProcessingEnabled(boolean isInMemoryProcessingEnabled) {
        this.isInMemoryProcessingEnabled = isInMemoryProcessingEnabled;
        this.fireProcessingModeChanged();
    }

    public boolean isCharsetSupport() {
        return this.charsetSupport;
    }

    public void setCharsetSupport(boolean charsetSupport) {
        this.charsetSupport = charsetSupport;
        this.fireCharsetSupportChanged();
    }

    private void fireCharsetSupportChanged() {
        SedaContextEvent event = new SedaContextEvent(SedaContextEvent.SedaContextEventType.CHARSET_SUPPORT_CHANGED);
        this.listeners.forEach(listener -> listener.contextChanged(event));
    }

    private void fireProcessingModeChanged() {
        SedaContextEvent event = new SedaContextEvent(SedaContextEvent.SedaContextEventType.PROCESSING_MODE_CHANGED);
        this.listeners.forEach(listener -> listener.contextChanged(event));
    }

    public void addSedaContextListener(SedaContextListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeSedaContextListener(SedaContextListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean containsSedaContextListener(SedaContextListener listener) {
        return this.listeners.contains(listener);
    }
}

