/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.sing_group.seda.cli.SedaCommand;
import org.sing_group.seda.cli.parameters.SequenceTranslationCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.TranslateSequenceNamesSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.translation.TranslateSequencesTransformationProvider;

public class TranslateSequencesCommand
extends SedaCommand {
    private SequenceTranslationCliParameters sequenceTranslationCliParameters;

    @Override
    public String getName() {
        return "translate";
    }

    @Override
    public String getDescriptiveName() {
        return "Translate";
    }

    @Override
    public String getDescription() {
        return "Translate nucleic acid sequences to their corresponding amino acid sequences.";
    }

    @Override
    protected String getSedaGroup() {
        return TranslateSequenceNamesSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        this.sequenceTranslationCliParameters = new SequenceTranslationCliParameters(false, false, "");
        return this.sequenceTranslationCliParameters.getOptionList();
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        TranslateSequencesTransformationProvider provider = new TranslateSequencesTransformationProvider();
        try {
            provider.setTranslationConfiguration(this.sequenceTranslationCliParameters.getSequenceTranslationConfiguration(parameters));
        }
        catch (IllegalArgumentException e) {
            TranslateSequencesCommand.formattedValidationError(e.getMessage() + ".");
        }
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, TranslateSequencesTransformationProvider.class);
    }
}

