/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.FlagOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sing_group.seda.cli.command.ReformatFastaCommand;
import org.sing_group.seda.cli.parameters.HeaderMatcherCliParameters;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.plugin.core.info.plugin.ConcatenateSequencesSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.concatenate.ConcatenateSequencesTransformationProvider;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

public class ConcatenateSequencesCommand
extends ReformatFastaCommand {
    public static final StringOption OPTION_NAME = new StringOption("name", "n", "The name of the merged file.", true, true);
    public static final FlagOption OPTION_MERGE_DESCRIPTIONS = new FlagOption("merge", "m", "Whether the sequence descriptions must be added to the concatenated sequences or not.");
    public static final HeaderMatcherCliParameters OPTIONS_HEADER_MATCHER = new HeaderMatcherCliParameters();

    @Override
    public String getName() {
        return "concatenate";
    }

    @Override
    public String getDescriptiveName() {
        return "Concatenate sequences";
    }

    @Override
    public String getDescription() {
        return "Concatenate sequences from selected files, according to FASTA header information, into a single output FASTA.";
    }

    @Override
    protected String getSedaGroup() {
        return ConcatenateSequencesSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.add(OPTION_NAME);
        options.add(OPTION_MERGE_DESCRIPTIONS);
        options.addAll(OPTIONS_HEADER_MATCHER.getOptionList());
        options.addAll(super.createSedaOptions());
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        ConcatenateSequencesTransformationProvider provider = new ConcatenateSequencesTransformationProvider();
        String mergeName = parameters.getSingleValueString(OPTION_NAME);
        if (mergeName.isEmpty()) {
            ConcatenateSequencesCommand.formattedValidationError("The merge name cant be empty");
        }
        provider.setMergeName(mergeName);
        provider.setMergeDescriptions(parameters.hasFlag(OPTION_MERGE_DESCRIPTIONS));
        provider.setHeaderMatcher(OPTIONS_HEADER_MATCHER.getHeaderMatcher(parameters));
        provider.setReformatFastaTransformationProvider((ReformatFastaTransformationProvider)super.getTransformation(parameters));
        return provider;
    }

    @Override
    protected List<Option<?>> getMandatoryOptions() {
        return Arrays.asList(OPTION_NAME);
    }

    @Override
    protected ConcatenateSequencesTransformationProvider getTransformation(File parametersFile) throws IOException {
        return (ConcatenateSequencesTransformationProvider)new JsonObjectReader().read(parametersFile, ConcatenateSequencesTransformationProvider.class);
    }
}

