/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.cli.command;

import es.uvigo.ei.sing.yacli.command.option.DefaultValuedStringOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sing_group.seda.cli.command.ReformatFastaCommand;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.datatype.SequenceTarget;
import org.sing_group.seda.plugin.core.info.plugin.CompareSequencesSedaPluginInfo;
import org.sing_group.seda.plugin.spi.TransformationProvider;
import org.sing_group.seda.transformation.provider.compare.CompareSequencesGroupDatasetTransformationProvider;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;

public class CompareSequencesCommand
extends ReformatFastaCommand {
    public static final DefaultValuedStringOption OPTION_SEQUENCE_TARGET = new DefaultValuedStringOption("sequence-target", "st", CompareSequencesSedaPluginInfo.PARAM_SEQUENCE_TARGET_HELP, SequenceTarget.SEQUENCE.toString().toLowerCase());

    @Override
    public String getName() {
        return "compare";
    }

    @Override
    public String getDescriptiveName() {
        return "Compare";
    }

    @Override
    public String getDescription() {
        return "Make all possible pairwise comparisons of selected files to find common and unique sequences.";
    }

    @Override
    protected String getSedaGroup() {
        return CompareSequencesSedaPluginInfo.GROUP;
    }

    @Override
    protected List<Option<?>> createSedaOptions() {
        ArrayList options = new ArrayList();
        options.add(OPTION_SEQUENCE_TARGET);
        options.addAll(super.createSedaOptions());
        return options;
    }

    @Override
    protected TransformationProvider getTransformation(Parameters parameters) {
        CompareSequencesGroupDatasetTransformationProvider provider = new CompareSequencesGroupDatasetTransformationProvider();
        SequenceTarget sequenceTarget = null;
        try {
            sequenceTarget = SequenceTarget.valueOf(parameters.getSingleValue(OPTION_SEQUENCE_TARGET).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            CompareSequencesCommand.invalidEnumValue(OPTION_SEQUENCE_TARGET);
        }
        provider.setSequenceTarget(sequenceTarget);
        provider.setReformatFastaTransformationProvider((ReformatFastaTransformationProvider)super.getTransformation(parameters));
        return provider;
    }

    @Override
    protected TransformationProvider getTransformation(File parametersFile) throws IOException {
        return (TransformationProvider)new JsonObjectReader().read(parametersFile, CompareSequencesGroupDatasetTransformationProvider.class);
    }
}

