/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.yacli.command.option;

import es.uvigo.ei.sing.yacli.command.option.AbstractOptionConverter;
import es.uvigo.ei.sing.yacli.command.option.DefaultValuedOption;
import es.uvigo.ei.sing.yacli.command.option.OptionCategory;
import es.uvigo.ei.sing.yacli.command.parameter.SingleParameterValue;
import java.util.List;

public class EnumOption<T extends Enum<T>>
extends DefaultValuedOption<T> {
    public EnumOption(String paramName, String shortName, String description, T defaultValue) {
        super(paramName, shortName, description, ((Enum)defaultValue).name(), new EnumConverter(((Enum)defaultValue).getDeclaringClass()));
    }

    public EnumOption(String paramName, String shortName, String description, Class<T> enumType, String defaultValue) {
        super(paramName, shortName, description, defaultValue, new EnumConverter<T>(enumType));
    }

    public EnumOption(String paramName, String shortName, String description, T defaultValue, boolean optional, boolean requiresValue, boolean isMultiple) {
        super(paramName, shortName, description, ((Enum)defaultValue).name(), optional, requiresValue, isMultiple, new EnumConverter(((Enum)defaultValue).getDeclaringClass()));
    }

    public EnumOption(String paramName, String shortName, String description, Class<T> enumType, String defaultValue, boolean optional, boolean requiresValue, boolean isMultiple) {
        super(paramName, shortName, description, defaultValue, optional, requiresValue, isMultiple, new EnumConverter<T>(enumType));
    }

    public EnumOption(List<OptionCategory> categories, String paramName, String shortName, String description, T defaultValue) {
        super(categories, paramName, shortName, description, ((Enum)defaultValue).name(), new EnumConverter(((Enum)defaultValue).getDeclaringClass()));
    }

    public EnumOption(List<OptionCategory> categories, String paramName, String shortName, String description, Class<T> enumType, String defaultValue) {
        super(categories, paramName, shortName, description, defaultValue, new EnumConverter<T>(enumType));
    }

    public EnumOption(List<OptionCategory> categories, String paramName, String shortName, String description, T defaultValue, boolean optional, boolean requiresValue, boolean isMultiple) {
        super(categories, paramName, shortName, description, ((Enum)defaultValue).name(), optional, requiresValue, isMultiple, new EnumConverter(((Enum)defaultValue).getDeclaringClass()));
    }

    public EnumOption(List<OptionCategory> categories, String paramName, String shortName, String description, Class<T> enumType, String defaultValue, boolean optional, boolean requiresValue, boolean isMultiple) {
        super(categories, paramName, shortName, description, defaultValue, optional, requiresValue, isMultiple, new EnumConverter<T>(enumType));
    }

    private static final class EnumConverter<E extends Enum<E>>
    extends AbstractOptionConverter<E> {
        private final Class<E> enumType;

        public EnumConverter(Class<E> enumType) {
            this.enumType = enumType;
        }

        @Override
        public Class<E> getTargetClass() {
            return this.enumType;
        }

        @Override
        public boolean canConvert(SingleParameterValue value) {
            try {
                Enum.valueOf(this.enumType, value.getValue());
                return true;
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return false;
            }
        }

        @Override
        public E convert(SingleParameterValue value) {
            return Enum.valueOf(this.enumType, value.getValue());
        }
    }
}

