/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.tool.ca;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalDirectionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReferenceType;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.parser.tool.ca.CatalyticActivity;
import uk.ac.ebi.uniprot.parser.tool.ca.CatalyticActivityRepository;
import uk.ac.ebi.uniprot.parser.tool.ca.CatalyticActivityValidator;

public class DefaultCatalyticActivityValidator
implements CatalyticActivityValidator {
    private static final String RHEA_PREFIX = "RHEA:";
    private final CatalyticActivityRepository repository;
    private final DefaultCommentFactory factory = DefaultCommentFactory.getInstance();

    public DefaultCatalyticActivityValidator(CatalyticActivityRepository repository) {
        this.repository = repository;
    }

    @Override
    public Optional<CatalyticActivityCommentStructured> validateAndConvert(CatalyticActivityCommentStructured comment) {
        Reaction reaction = comment.getReaction();
        if (reaction.getReactionReferences().isEmpty()) {
            CatalyticActivity ca = this.repository.getByOldText(reaction.getName());
            if (ca == null) {
                return Optional.empty();
            }
            String ec = reaction.getECNumber();
            if (Strings.isNullOrEmpty((String)ec) || ca.getEcs().contains(ec)) {
                return Optional.ofNullable(comment);
            }
            return Optional.empty();
        }
        Optional<ReactionReference> rheaRef = reaction.getReactionReferences().stream().filter(val -> val.getType() == ReactionReferenceType.RHEA && val.getId().startsWith(RHEA_PREFIX)).findFirst();
        if (!rheaRef.isPresent()) {
            return Optional.empty();
        }
        CatalyticActivity ca = this.repository.getByRheaId(rheaRef.get().getId());
        if (ca == null) {
            return Optional.empty();
        }
        CatalyticActivityCommentStructured newComment = this.factory.buildCatalyticActivityCommentStructured();
        newComment.setReaction(this.transformReaction(reaction, ca, rheaRef.get()));
        List<PhysiologicalReaction> physioReactions = comment.getPhysiologicalReactions().stream().map(val -> this.transformPhysiologicalReaction(ca, (PhysiologicalReaction)val)).filter(val -> val != null).collect(Collectors.toList());
        newComment.setPhysiologicalReactions(physioReactions);
        return Optional.ofNullable(newComment);
    }

    private Reaction transformReaction(Reaction reaction, CatalyticActivity ca, ReactionReference rhea) {
        Reaction newReaction = this.factory.buildReaction();
        newReaction.setName(ca.getText());
        ArrayList<ReactionReference> xrefs = new ArrayList<ReactionReference>();
        xrefs.add(this.createReactRef(rhea.getType(), rhea.getId()));
        ca.getReactantIds().stream().map(this::parseReactantId).forEach(val -> xrefs.add((ReactionReference)val));
        newReaction.setReactionReferences(xrefs);
        if (ca.getEcs().contains(reaction.getECNumber())) {
            newReaction.setECNumber(reaction.getECNumber());
        }
        newReaction.setEvidenceIds(reaction.getEvidenceIds());
        return newReaction;
    }

    private PhysiologicalReaction transformPhysiologicalReaction(CatalyticActivity ca, PhysiologicalReaction physioReaction) {
        ReactionReference xref = physioReaction.getReactionReference();
        if (xref == null || xref.getType() != ReactionReferenceType.RHEA) {
            return null;
        }
        PhysiologicalDirectionType type = physioReaction.getDirectionType();
        if (type == PhysiologicalDirectionType.LEFT_TO_RIGHT ? xref.getId().equals(ca.getRheaLr()) : type == PhysiologicalDirectionType.RIGHT_TO_LEFT && xref.getId().equals(ca.getRheaRl())) {
            return this.copy(physioReaction);
        }
        return null;
    }

    private PhysiologicalReaction copy(PhysiologicalReaction data) {
        PhysiologicalReaction pr = this.factory.buildPhysiologicalReaction();
        pr.setDirectionType(data.getDirectionType());
        pr.setEvidenceIds(data.getEvidenceIds());
        pr.setReactionReference(this.createReactRef(data.getReactionReference().getType(), data.getReactionReference().getId()));
        return pr;
    }

    private ReactionReference parseReactantId(String reactantId) {
        int index = reactantId.indexOf(58);
        String type = reactantId.substring(0, index);
        String id = reactantId.substring(index + 1);
        return this.createReactRef(ReactionReferenceType.typeOf(type), id);
    }

    private ReactionReference createReactRef(ReactionReferenceType type, String id) {
        ReactionReference ref = this.factory.buildReactionReference();
        ref.setType(type);
        ref.setId(id);
        return ref;
    }
}

