/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.og;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.parser.impl.EvidenceIdCollector;
import uk.ac.ebi.uniprot.parser.impl.og.OgLineObject;

public class OgLineConverter
extends EvidenceIdCollector
implements Converter<OgLineObject, List<Organelle>> {
    private final DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();

    @Override
    public List<Organelle> convert(OgLineObject f) {
        ArrayList<Organelle> organelles = new ArrayList<Organelle>();
        Map<Object, List<EvidenceId>> evidenceMap = EvidenceHelper.convert(f.getEvidenceInfo());
        this.addAll(evidenceMap.values());
        for (OgLineObject.OgEnum ogEnum : f.ogs) {
            GeneEncodingType type = GeneEncodingType.UNKOWN;
            switch (ogEnum) {
                case HYDROGENOSOME: {
                    type = GeneEncodingType.HYDROGENOSOME;
                    break;
                }
                case MITOCHONDRION: {
                    type = GeneEncodingType.MITOCHONDRION;
                    break;
                }
                case NUCLEOMORPH: {
                    type = GeneEncodingType.NUCLEOMORPH;
                    break;
                }
                case PLASTID: {
                    type = GeneEncodingType.PLASTID;
                    break;
                }
                case PLASTID_APICOPLAST: {
                    type = GeneEncodingType.APICOPLAST_PLASTID;
                    break;
                }
                case PLASTID_CHLOROPLAST: {
                    type = GeneEncodingType.CHLOROPLAST_PLASTID;
                    break;
                }
                case PLASTID_ORGANELLAR_CHROMATOPHORE: {
                    type = GeneEncodingType.CHROMATOPHORE_PLASTID;
                    break;
                }
                case PLASTID_CYANELLE: {
                    type = GeneEncodingType.CYANELLE_PLASTID;
                    break;
                }
                case PLASTID_NON_PHOTOSYNTHETIC: {
                    type = GeneEncodingType.NON_PHOTOSYNTHETIC_PLASTID;
                    break;
                }
                case PLASMID: {
                    type = GeneEncodingType.PLASMID;
                    break;
                }
                default: {
                    type = GeneEncodingType.UNKOWN;
                }
            }
            Organelle org = this.factory.buildOrganelle(type);
            EvidenceHelper.setEvidences(org, evidenceMap, (Object)ogEnum);
            organelles.add(org);
        }
        for (String val : f.plasmidNames) {
            Organelle org = this.factory.buildOrganelle(GeneEncodingType.PLASMID);
            org.setValue(val);
            EvidenceHelper.setEvidences(org, evidenceMap, val);
            organelles.add(org);
        }
        return organelles;
    }
}

