/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.dr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLineType;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.DatabaseTypeNotExistException;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.parser.impl.EvidenceIdCollector;
import uk.ac.ebi.uniprot.parser.impl.dr.DrLineObject;
import uk.ac.ebi.uniprot.parser.impl.dr.UniProtDrObjects;

public class DrLineConverter
extends EvidenceIdCollector
implements Converter<DrLineObject, UniProtDrObjects> {
    private final DefaultXRefFactory factory = DefaultXRefFactory.getInstance();
    private boolean ignoreWrongDR = false;

    public DrLineConverter() {
    }

    public DrLineConverter(boolean ignoreWrongDR) {
        this.ignoreWrongDR = ignoreWrongDR;
    }

    @Override
    public UniProtDrObjects convert(DrLineObject f) {
        UniProtDrObjects uniProtDrObjects = new UniProtDrObjects();
        if (f == null) {
            return uniProtDrObjects;
        }
        Map<Object, List<EvidenceId>> evidences = EvidenceHelper.convert(f.getEvidenceInfo());
        this.addAll(evidences.values());
        for (DrLineObject.DrObject drline : f.drObjects) {
            if (drline.ssLineValue != null) {
                this.addSSProsites(drline, uniProtDrObjects);
                continue;
            }
            this.addDrLine(drline, uniProtDrObjects, evidences);
        }
        return uniProtDrObjects;
    }

    private void addSSProsites(DrLineObject.DrObject drline, UniProtDrObjects uniProtDrObjects) {
        InternalLine il = null;
        if (drline.ssLineValue != null) {
            if (uniProtDrObjects.ssProsites == null) {
                uniProtDrObjects.ssProsites = new ArrayList<InternalLine>();
            }
            il = DefaultUniProtFactory.getInstance().buildInternalLine();
            il.setInternalLineType(InternalLineType.PROSITE);
            il.setValue(drline.ssLineValue);
            uniProtDrObjects.ssProsites.add(il);
        }
    }

    private void addDrLine(DrLineObject.DrObject drline, UniProtDrObjects uniProtDrObjects, Map<Object, List<EvidenceId>> evidences) {
        if (drline.ssLineValue != null) {
            return;
        }
        DatabaseCrossReference xref = null;
        try {
            xref = this.factory.buildDatabaseCrossReference(drline.dbName);
            if (xref.getDatabase() == DatabaseType.UNKNOWN) {
                if (this.ignoreWrongDR) {
                    return;
                }
                throw new DatabaseTypeNotExistException(drline.dbName);
            }
        }
        catch (Exception e) {
            if (this.ignoreWrongDR) {
                return;
            }
            throw new DatabaseTypeNotExistException(drline.dbName);
        }
        xref.setPrimaryId(this.factory.buildXDBAttribute(drline.attributes.get(0)));
        xref.setDescription(this.factory.buildXDBAttribute(drline.attributes.get(1)));
        try {
            if (xref.hasThird()) {
                xref.setThird(this.factory.buildXDBAttribute(drline.attributes.get(2)));
                if (xref.hasFourth()) {
                    xref.setFourth(this.factory.buildXDBAttribute(drline.attributes.get(3)));
                }
            }
            EvidenceHelper.setEvidences(xref, evidences, drline);
            uniProtDrObjects.drObjects.add(xref);
            if (drline.isoform != null && !drline.isoform.isEmpty()) {
                xref.setIsoformId(DefaultUniProtFactory.getInstance().buildUniProtIsoformId(drline.isoform));
            }
        }
        catch (Exception e) {
            if (this.ignoreWrongDR) {
                System.out.println(e.getMessage());
            }
            throw e;
        }
    }
}

