/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.uniref;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniref.member.OverlapRegion;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefMember;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniref.AvroUniRefMember;

public abstract class AbstractUniRefMemberConverter<T extends UniRefMember>
implements Converter<T, AvroUniRefMember> {
    protected final DefaultUniRefFactory factory = DefaultUniRefFactory.getInstance();

    protected String getSequence(T u) {
        return null;
    }

    protected void setSequence(CharSequence sequence, T u) {
    }

    protected abstract T createUniRefMember();

    @Override
    public AvroUniRefMember toAvro(T u) {
        AvroUniRefMember.Builder builder = AvroUniRefMember.newBuilder();
        builder.setLength(u.getLength()).setMemberId(u.getMemberId().getValue()).setNcbiTaxon(u.getNCBITaxonomy().getValue()).setOrganism(u.getSourceOrganism().getValue()).setProteinName(u.getProteinName().getValue()).setType(u.getType().getValue()).setSeed(u.isSeed()).setUniparcId(u.getUniParcAccession().getValue()).setUniref100Id(u.getUniRef100EntryId().getValue()).setUniref90Id(u.getUniRef90EntryId().getValue()).setUniref50Id(u.getUniRef50EntryId().getValue());
        String overlapRegion = this.getOverlapRegion(u.getOverlapRegion());
        if (overlapRegion != null) {
            builder.setOverlapRegion(overlapRegion);
        }
        builder.setAccessions(u.getUniProtAccessions().stream().map(val -> val.getValue()).collect(Collectors.toList()));
        String sequence = this.getSequence(u);
        if (sequence != null) {
            builder.setSequence(sequence);
        }
        return builder.build();
    }

    @Override
    public T fromAvro(AvroUniRefMember a) {
        T member = this.createUniRefMember();
        member.setLength(a.getLength());
        member.setMemberId(this.factory.buildMemberId(a.getMemberId().toString()));
        member.setNCBITaxonomy(this.factory.buildMemberNCBITaxonomy(a.getNcbiTaxon().toString()));
        if (a.getOverlapRegion() != null) {
            member.setOverlapRegion(this.convertOverlapRegion(a.getOverlapRegion().toString()));
        }
        member.setProteinName(this.factory.buildMemberProteinName(a.getProteinName().toString()));
        member.setSeed(a.getSeed());
        member.setSourceOrganism(this.factory.buildMemberSourceOrganism(a.getOrganism().toString()));
        member.setType(this.factory.buildMemberType(a.getType().toString()));
        member.setUniParcAccession(this.factory.buildMemberUniParcAccession(a.getUniparcId().toString()));
        member.setUniProtAccessions(a.getAccessions().stream().map(val -> val.toString()).map(val -> this.factory.buildMemberUniProtAccession((String)val)).collect(Collectors.toList()));
        member.setUniRef100EntryId(this.factory.buildUniRefEntryId(a.getUniref100Id().toString()));
        member.setUniRef90EntryId(this.factory.buildUniRefEntryId(a.getUniref90Id().toString()));
        member.setUniRef50EntryId(this.factory.buildUniRefEntryId(a.getUniref50Id().toString()));
        this.setSequence(a.getSequence(), member);
        return member;
    }

    private String getOverlapRegion(OverlapRegion olr) {
        if (olr != null) {
            if (olr.getStart() == 0 && olr.getEnd() == 0) {
                return null;
            }
            return "" + olr.getStart() + "-" + olr.getEnd();
        }
        return null;
    }

    private OverlapRegion convertOverlapRegion(String olr) {
        String[] val = olr.split("-");
        if (val.length == 1) {
            return this.factory.buildMemberOverlapRegion();
        }
        return this.factory.buildMemberOverlapRegion(Integer.parseInt(val[0]), Integer.parseInt(val[1]));
    }
}

