/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Location;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class SubCellLocationConverter
implements Converter<SubcellularLocation, Location> {
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public Location toAvro(SubcellularLocation sub) {
        String val;
        Location.Builder builder = Location.newBuilder();
        if (sub.hasLocation()) {
            val = sub.getLocation().getValue() + ConverterHelper.buildCommentStatus(sub.getLocation());
            builder.setLocation(ConverterHelper.convert(val, sub.getLocation().getEvidenceIds()));
        }
        if (sub.hasOrientation()) {
            val = sub.getOrientation().getValue() + ConverterHelper.buildCommentStatus(sub.getOrientation());
            builder.setOrientation(ConverterHelper.convert(val, sub.getOrientation().getEvidenceIds()));
        }
        if (sub.hasTopology()) {
            val = sub.getTopology().getValue() + ConverterHelper.buildCommentStatus(sub.getTopology());
            builder.setTopology(ConverterHelper.convert(val, sub.getTopology().getEvidenceIds()));
        }
        return builder.build();
    }

    @Override
    public SubcellularLocation fromAvro(Location obj) {
        SubcellularLocation location = DefaultCommentFactory.getInstance().buildSubcellularLocation();
        if (obj.getLocation() != null) {
            location.setLocation(this.convert(obj.getLocation()));
        }
        if (obj.getOrientation() != null) {
            location.setOrientation(this.convert(obj.getOrientation()));
        }
        if (obj.getTopology() != null) {
            location.setTopology(this.convert(obj.getTopology()));
        }
        return location;
    }

    private SubcellularLocationValue convert(EvidencedString evStr) {
        String val = evStr.getKey().toString();
        List<CharSequence> evidences = evStr.getEvidence();
        SubcellularLocationValue locValue = DefaultCommentFactory.getInstance().buildSubcellularLocationValue();
        val = ConverterHelper.setCommentStatus(val, locValue);
        locValue.setValue(val);
        locValue.setEvidenceIds(this.evidenceConverter.fromAvro(evidences));
        return locValue;
    }
}

