/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.BPCPAbsorptionConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.BPCPKineticsConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.BiophysicochemicalProperties;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class BPCPCommentConverter
extends AbstractCommentConverter<BioPhysicoChemicalPropertiesComment> {
    private final BPCPKineticsConverter kineticsConverter = new BPCPKineticsConverter();
    private final BPCPAbsorptionConverter absorptionConverter = new BPCPAbsorptionConverter();

    @Override
    protected Object convertToAvro(BioPhysicoChemicalPropertiesComment comment) {
        BiophysicochemicalProperties.Builder builder = BiophysicochemicalProperties.newBuilder();
        if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
            builder.setMolecule(comment.getMolecule());
        }
        if (comment.hasAbsorptionProperty()) {
            builder.setAbsorption(this.absorptionConverter.toAvro(comment.getAbsorption()));
        }
        if (comment.hasKineticParametersProperty()) {
            builder.setKinetics(this.kineticsConverter.toAvro(comment.getKineticParameters()));
        }
        if (comment.hasPHDependenceProperty()) {
            PHDependence phDep = comment.getPHDependence();
            builder.setPhDependence(phDep.getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        if (comment.hasRedoxPotentialProperty()) {
            RedoxPotential redox = comment.getRedoxPotential();
            builder.setRedoxPotential(redox.getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        if (comment.hasTemperatureDependenceProperty()) {
            TemperatureDependence tempDep = comment.getTemperatureDependence();
            builder.setTemperatureDependence(tempDep.getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    protected BioPhysicoChemicalPropertiesComment convertFromAvro(CommentType type, Object avroObj) {
        BioPhysicoChemicalPropertiesComment comment = (BioPhysicoChemicalPropertiesComment)factory.buildComment(type);
        BiophysicochemicalProperties bpcProperty = (BiophysicochemicalProperties)((Object)avroObj);
        if (bpcProperty.getMolecule() != null) {
            comment.setMolecule(bpcProperty.getMolecule().toString());
        }
        if (bpcProperty.getAbsorption() != null) {
            comment.setAbsorption(this.absorptionConverter.fromAvro(bpcProperty.getAbsorption()));
        }
        if (bpcProperty.getKinetics() != null) {
            comment.setKineticParameters(this.kineticsConverter.fromAvro(bpcProperty.getKinetics()));
        }
        if (bpcProperty.getPhDependence() != null) {
            PHDependence phDep = factory.buildPHDependence();
            phDep.setTexts(bpcProperty.getPhDependence().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList()));
            comment.setPHDepencence(phDep);
        }
        if (bpcProperty.getRedoxPotential() != null) {
            RedoxPotential redox = factory.buildRedoxPotential();
            redox.setTexts(bpcProperty.getRedoxPotential().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList()));
            comment.setRedoxPotential(redox);
        }
        if (bpcProperty.getTemperatureDependence() != null) {
            TemperatureDependence tempDep = factory.buildTemperatureDependence();
            tempDep.setTexts(bpcProperty.getTemperatureDependence().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList()));
            comment.setTemperatureDependence(tempDep);
        }
        return comment;
    }
}

