/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.APIsoformConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.AlternativeProducts;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.Isoform;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class APCommentConverter
extends AbstractCommentConverter<AlternativeProductsComment> {
    private final APIsoformConverter isoformConverter = new APIsoformConverter();

    @Override
    protected Object convertToAvro(AlternativeProductsComment comment) {
        AlternativeProducts.Builder builder = AlternativeProducts.newBuilder();
        if (comment.getComment() != null && comment.getComment().getTexts() != null) {
            builder.setComment(comment.getComment().getTexts().stream().map(v -> this.evidencedStringConverter.fromAvro((EvidencedValue)v)).collect(Collectors.toList()));
        }
        builder.setEvent(comment.getEvents().stream().map(v -> v.getValue()).collect(Collectors.toList()));
        builder.setIsoforms(comment.getIsoforms().stream().map(v -> this.isoformConverter.toAvro((AlternativeProductsIsoform)v)).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    protected AlternativeProductsComment convertFromAvro(CommentType type, Object avroObj) {
        AlternativeProductsComment comment = (AlternativeProductsComment)factory.buildComment(type);
        AlternativeProducts altProduct = (AlternativeProducts)((Object)avroObj);
        if (altProduct.getComment() != null) {
            AlternativeProductsCommentComment com = factory.buildAlternativeProductsCommentComment();
            List<EvidencedValue> evValues = altProduct.getComment().stream().map(v -> this.evidencedStringConverter.toAvro((EvidencedString)((Object)v))).collect(Collectors.toList());
            com.setTexts(evValues);
            comment.setComment(com);
        }
        comment.setEvents(altProduct.getEvent().stream().map(v -> factory.buildAlternativeProductsEvent(v.toString())).collect(Collectors.toList()));
        comment.setIsoforms(altProduct.getIsoforms().stream().map(v -> this.isoformConverter.fromAvro((Isoform)((Object)v))).collect(Collectors.toList()));
        return comment;
    }
}

