/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FlagType;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;

public class DescriptionFlagConverter
implements Converter<List<Flag>, String> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private static final String PRECURSOR_FRAGMENTS = "Precursor_Fragments";
    private static final String PRECURSOR_FRAGMENT = "Precursor_Fragment";
    private static final String FRAGMENTS = "Fragments";
    private static final String FRAGMENT = "Fragment";
    private static final String PRECURSOR = "Precursor";

    @Override
    public String toAvro(List<Flag> u) {
        if (u.size() == 0) {
            return null;
        }
        if (u.size() == 1) {
            switch (u.get(0).getFlagType()) {
                case PRECURSOR: {
                    return PRECURSOR;
                }
                case FRAGMENT: {
                    return FRAGMENT;
                }
                case FRAGMENTS: {
                    return FRAGMENTS;
                }
            }
        } else {
            boolean hasFragment = false;
            boolean hasPrecursor = false;
            boolean hasFragments = false;
            for (Flag f : u) {
                if (f.getFlagType() == FlagType.FRAGMENT) {
                    hasFragment = true;
                    continue;
                }
                if (f.getFlagType() == FlagType.PRECURSOR) {
                    hasPrecursor = true;
                    continue;
                }
                if (f.getFlagType() != FlagType.FRAGMENTS) continue;
                hasFragments = true;
            }
            if (hasFragment && hasPrecursor) {
                return PRECURSOR_FRAGMENT;
            }
            if (hasFragments && hasPrecursor) {
                return PRECURSOR_FRAGMENTS;
            }
            if (hasFragment) {
                return FRAGMENT;
            }
            if (hasPrecursor) {
                return PRECURSOR;
            }
            if (hasFragments) {
                return FRAGMENTS;
            }
        }
        return FRAGMENT;
    }

    @Override
    public List<Flag> fromAvro(String a) {
        ArrayList<Flag> flags = new ArrayList<Flag>();
        if (a == null) {
            return flags;
        }
        if (a.equals(PRECURSOR)) {
            flags.add(factory.buildFlag(FlagType.PRECURSOR));
        } else if (a.equals(FRAGMENT)) {
            flags.add(factory.buildFlag(FlagType.FRAGMENT));
        } else if (a.equals(FRAGMENTS)) {
            flags.add(factory.buildFlag(FlagType.FRAGMENTS));
        } else if (a.equals(PRECURSOR_FRAGMENT)) {
            flags.add(factory.buildFlag(FlagType.PRECURSOR));
            flags.add(factory.buildFlag(FlagType.FRAGMENT));
        } else if (a.equals(PRECURSOR_FRAGMENTS)) {
            flags.add(factory.buildFlag(FlagType.PRECURSOR));
            flags.add(factory.buildFlag(FlagType.FRAGMENTS));
        }
        return flags;
    }
}

