/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.query.impl;

import uk.ac.ebi.uniprot.dataservice.query.Query;

public class BlockJoinQuery
implements Query {
    private BlockJoinType type;
    private Query parentQuery;
    private Query childQuery;
    private Query joinQuery;

    private BlockJoinQuery() {
    }

    public BlockJoinQuery(BlockJoinType type, Query joinQuery, Query parentQuery, Query childQuery) {
        this.type = type;
        this.joinQuery = joinQuery;
        this.parentQuery = parentQuery;
        this.childQuery = childQuery;
    }

    @Override
    public Query and(Query query) {
        throw new UnsupportedOperationException("BlockJoinQuery must be a root query and does not support composite queries");
    }

    @Override
    public Query or(Query query) {
        throw new UnsupportedOperationException("BlockJoinQuery must be a root query and does not support composite queries");
    }

    @Override
    public Query not() {
        throw new UnsupportedOperationException("BlockJoinQuery must be a root query and does not support composite queries");
    }

    @Override
    public String getQueryString() {
        String queryString = "";
        switch (this.type) {
            case parent: {
                queryString = "{!parent which='" + this.joinQuery.getQueryString() + "'}";
                if (this.childQuery == null) break;
                queryString = queryString + " " + this.childQuery.getQueryString();
                break;
            }
            case child: {
                queryString = "{!child of='" + this.joinQuery.getQueryString() + "'}";
                if (this.parentQuery == null) break;
                queryString = queryString + " " + this.parentQuery.getQueryString();
            }
        }
        return queryString;
    }

    public Query getFilterQuery() {
        Query result = null;
        switch (this.type) {
            case parent: {
                if (this.parentQuery == null) break;
                result = this.parentQuery;
                break;
            }
            case child: {
                if (this.childQuery == null) break;
                result = this.childQuery;
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEverything() {
        return false;
    }

    public static enum BlockJoinType {
        parent,
        child;

    }
}

