/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniref.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefService;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.UniRefEntryStoreResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.UniRefServiceImpl;
import uk.ac.ebi.uniprot.dataservice.document.uniref.UniRefDocument;
import uk.ac.ebi.uniprot.dataservice.voldemort.VoldemortClient;
import uk.ac.ebi.uniprot.dataservice.voldemort.uniref.VoldemortInMemoryUniRefEntryStore;
import uk.ac.ebi.uniprot.dataservice.voldemort.uniref.VoldemortRemoteUniRefEntryStore;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniref.AvroUniRef;

public class UniRefGuiceModule
extends AbstractModule {
    public static final String UNIREF_SERVICE_URL = "unirefServiceURL";
    private final String serviceUrl;
    private final String voldemortUrl;
    private final String voldemortStoreName;
    private final String avroBinaryDocumentFieldName;
    private final String documentId;

    public UniRefGuiceModule(Properties configProperties) {
        this.serviceUrl = configProperties.getProperty(UNIREF_SERVICE_URL);
        this.voldemortUrl = configProperties.getProperty("unirefVoldemortUrl");
        this.voldemortStoreName = configProperties.getProperty("unirefVoldemortStoreName");
        this.avroBinaryDocumentFieldName = configProperties.getProperty("unirefAvroFieldName");
        this.documentId = configProperties.getProperty("unirefDocumentId");
    }

    protected void configure() {
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"UNIREF_REMOTE_SERVER_URL")).to(this.serviceUrl);
        this.bind(UniRefService.class).to(UniRefServiceImpl.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"unirefAvroFieldName")).to(this.avroBinaryDocumentFieldName);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"unirefDocumentId")).to(this.documentId);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"unirefVoldemortUrl")).to(this.voldemortUrl);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"unirefVoldemortStoreName")).to(this.voldemortStoreName);
        if (this.voldemortUrl.equals("inMemory")) {
            this.bind((TypeLiteral)new TypeLiteral<VoldemortClient<AvroUniRef>>(){}).toInstance((Object)VoldemortInMemoryUniRefEntryStore.getInstance((String)this.voldemortStoreName));
        } else {
            this.bind((TypeLiteral)new TypeLiteral<VoldemortClient<AvroUniRef>>(){}).toInstance((Object)new VoldemortRemoteUniRefEntryStore(this.voldemortStoreName, this.voldemortUrl));
        }
        this.getResponseFactoryMapBinder().addBinding(UniRefDocument.class).to(UniRefEntryStoreResponseFactory.class);
    }

    private MapBinder<Class<?>, ResponseFactory> getResponseFactoryMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<ResponseFactory>(){});
    }
}

