/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniprot.impl;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.document.uniprot.UniProtDocument;
import uk.ac.ebi.uniprot.dataservice.serializer.EntrySerializer;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EntryConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.impl.AvroSerializer;

class EntryResponseAdaptor
implements ResponseAdaptor<UniProtEntry, UniProtDocument> {
    private static final Logger logger = LoggerFactory.getLogger(EntryResponseAdaptor.class);
    private static EntryResponseAdaptor instance;
    private final EntrySerializer serializer;

    public static EntryResponseAdaptor getInstance() {
        if (instance == null) {
            EntryConverter converter = new EntryConverter();
            AvroSerializer avroSerializer = new AvroSerializer(converter);
            instance = new EntryResponseAdaptor(avroSerializer);
        }
        return instance;
    }

    @Inject
    public EntryResponseAdaptor(EntrySerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public UniProtEntry adapt(UniProtDocument doc) {
        if (doc != null && doc.avro_binray != null) {
            try {
                byte[] bytes = doc.avro_binray;
                UniProtEntry deserialize = this.serializer.deserialize(bytes);
                return deserialize;
            }
            catch (Exception e) {
                logger.error("Unable to deserialize object from avro_binray", (Throwable)e);
                return null;
            }
        }
        if (doc != null) {
            logger.error("entry=" + doc.accession + " does not have avro binary");
            return null;
        }
        return null;
    }
}

