/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.examples;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.Client;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastInput;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastResult;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniParcBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniParcHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniRefBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniRefHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;

public class BlastDemo {
    private static final Logger logger = LoggerFactory.getLogger(BlastDemo.class);

    public static void main(String[] args) {
        BlastDemo.runUniProtBlastExample();
        BlastDemo.runUniParcBlastExample();
        BlastDemo.runUniRefBlastExample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUniProtBlastExample() {
        logger.info("Start UniProt blast");
        String querySequence = "MES00005665499\nMSNHGFAYFFTSYQSLSLDSSSPPPSPHPRAHASSRFPPRARAVASFHTSCKMARTKQTA\nRKSTGGKAPRKQLATKAARKSAPATGGVKKPHRYRPGTVALREIRKYQKSTELLIRKLPF\nQRLVREIAQDFKTDLRFQSSAVLALQEASEAYLVGLFEDTNLCAIHAKRVTIMPKDVQLA\nRRIRGERA";
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniProtBlastService uniProtBlastService = serviceFactoryInstance.getUniProtBlastService();
        uniProtBlastService.start();
        BlastInput input = new BlastInput.Builder(DatabaseOption.SWISSPROT, querySequence).build();
        CompletableFuture<BlastResult<UniProtHit>> resultFuture = uniProtBlastService.runBlast(input);
        try {
            BlastResult<UniProtHit> blastResult = resultFuture.get();
            logger.info("Number of blast hits: " + blastResult.getNumberOfHits());
            for (UniProtHit hit : blastResult.hits()) {
                System.out.println(hit.getSummary().getEntryAc() + "\t" + hit.getEntry().getPrimaryUniProtAccession().getValue());
            }
        }
        catch (ExecutionException e) {
            logger.error(e.getCause().getMessage());
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        finally {
            uniProtBlastService.stop();
        }
        logger.info("Finished UniProt blast");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUniParcBlastExample() {
        logger.info("Start UniParc blast");
        String querySequence = "MGAAASIQTTVNTLSERISSKLEQEANASAQTKCDIEIGNFYIRQNHGCNLTVKNMCSAD\nADAQLDAVLSAATETYSGLTPEQKAYVPAMFTAALNIQTSVNTVVRDFENYVKQTCNSSA\nVVDNKLKIQNVIIDECYGAPGSPTNLEFINTGSSKGNCAIKALMQLTTKATTQIAPKQVA\nGTGVQFYMIVIGVIILAALFMYYAKRMLFTSTNDKIKLILANKENVHWTTYMDTFFRTSP\nMVIATTDMQN";
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniParcBlastService uniParcBlastService = serviceFactoryInstance.getUniParcBlastService();
        uniParcBlastService.start();
        BlastInput input = new BlastInput.Builder(DatabaseOption.UNIPARC, querySequence).build();
        CompletableFuture<BlastResult<UniParcHit>> resultFuture = uniParcBlastService.runBlast(input);
        try {
            BlastResult<UniParcHit> blastResult = resultFuture.get();
            logger.info("Number of blast hits: " + blastResult.getNumberOfHits());
            for (UniParcHit hit : blastResult.hits()) {
                System.out.println(hit.getSummary().getEntryId());
                if (hit.getEntry() == null) continue;
                System.out.println("--" + hit.getEntry().getUniParcId().getValue());
            }
        }
        catch (ExecutionException e) {
            logger.error(e.getCause().getMessage());
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        finally {
            uniParcBlastService.stop();
        }
        logger.info("Finished UniParc blast");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUniRefBlastExample() {
        logger.info("Start UniRef blast");
        String querySequence = "MLRGSARTYWTLTGLWVLLRAGTLVVGLLFQRLFDALGAGGGVWLIIALVAAIEAGRLFL\nQFGVMINRLEPRVQYGTTARLRHALLGSALRGSEVTARTSPGESLRTVGEDVDETGFFVA\nWAPTNLAHWLFVAASVTVMMRIDAVVTGALLALLVLLTLVTALAHSRFLRHRRATRAASG\nEVAGALREMVGAVGAVQAAAAEPQVAAHVAGLNGARAEAAVREELYAVVQRTVIGNPAPI\nGVGVVLLLVAGRMDEGTFSVGDLALFAFYLQILTEALGSIGMLSVRLQRVSVALGRITNN\nLGCRLRRSLERASPPIASDAPGGTGEGAAAPDAGPEPAPPLRELAVRGLTARHPGAGHGI\nEDVDLVVERHTVTVVTGRVGSGKSTLVRAVLGLLPHERGTVLWNGEPIADPASFLVAPRC\nGYTPQVPCLFSGTVRENVLLGRDGAAFDEAVRLAVAEPDLAAMQDGPDTVVGPRGLRLSG\nGQIQRVAIARMLVGDPELVVLDDVSSALDPETEHLLWERLLDGTRTVLAVSHRPALLRAA\nDRVVVLEGGRVEASGTFEEVMAVSAEMGRIWTGAGPGGGDAGPAPQSPPAG";
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniRefBlastService uniRefBlastService = serviceFactoryInstance.getUniRefBlastService();
        uniRefBlastService.start();
        BlastInput input = new BlastInput.Builder(DatabaseOption.UNIREF_90, querySequence).build();
        CompletableFuture<BlastResult<UniRefHit>> resultFuture = uniRefBlastService.runBlast(input);
        try {
            BlastResult<UniRefHit> blastResult = resultFuture.get();
            logger.info("Number of blast hits: " + blastResult.getNumberOfHits());
            for (UniRefHit hit : blastResult.hits()) {
                System.out.println(hit.getSummary().getEntryId() + "\t" + hit.getEntry().getUniRefEntryId().getValue());
            }
        }
        catch (ExecutionException e) {
            logger.error(e.getCause().getMessage());
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        finally {
            uniRefBlastService.stop();
        }
        logger.info("Finished UniRef blast");
    }
}

