/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniRefHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.AbstractLazyHit;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefService;

class LazyUniRefHit
extends AbstractLazyHit<UniRefEntry>
implements UniRefHit {
    private final BlastSummary summary;
    private final AbstractLazyHit.ReadEntryService<UniRefEntry> readEntryService;

    public LazyUniRefHit(BlastSummary summary, UniRefService searchService) {
        if (summary == null) {
            throw new IllegalArgumentException("Can not instantiate object with null summary");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("Can not instantiate object with null search service");
        }
        this.summary = summary;
        this.readEntryService = new UniRefReadEntryService(searchService);
    }

    @Override
    public UniRefEntry getEntry() {
        return this.getEntry(this.summary.getEntryId(), this.readEntryService);
    }

    @Override
    public BlastSummary getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LazyUniRefHit)) {
            return false;
        }
        LazyUniRefHit that = (LazyUniRefHit)o;
        return this.summary.equals(that.summary);
    }

    public int hashCode() {
        return this.summary.hashCode();
    }

    public String toString() {
        return "UniProtHitImpl{summary=" + this.summary + '}';
    }

    private class UniRefReadEntryService
    implements AbstractLazyHit.ReadEntryService<UniRefEntry> {
        private UniRefService searchService;

        public UniRefReadEntryService(UniRefService searchService) {
            this.searchService = searchService;
        }

        @Override
        public UniRefEntry getEntry(String entryId) throws ServiceException {
            return this.searchService.getEntry(entryId);
        }
    }
}

