/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniref;

import java.util.Date;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import uk.ac.ebi.kraken.interfaces.factories.UniRefFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.common.XMLGregorianCalendarConverter;
import uk.ac.ebi.kraken.xml.jaxb.uniref.Entry;
import uk.ac.ebi.kraken.xml.jaxb.uniref.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniref.UniRefMemberHandler;
import uk.ac.ebi.kraken.xml.uniref.UniRefRepresentativeMemberHandler;

public class UniRefEntryHandler
implements GenericHandler<UniRefEntry, Entry> {
    private final ObjectFactory jaxbFactory = new ObjectFactory();
    private final UniRefFactory krakenFactory = DefaultUniRefFactory.getInstance();
    private final UniRefMemberHandler memberHandler = new UniRefMemberHandler();
    private final UniRefRepresentativeMemberHandler representativeMemberHandler = new UniRefRepresentativeMemberHandler();
    private final UniRefDatabaseType databaseType;

    public UniRefEntryHandler() {
        this(UniRefDatabaseType.UniRef100);
    }

    public UniRefEntryHandler(UniRefDatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    @Override
    public UniRefEntry fromXmlBinding(Entry jaxbEntry) {
        UniRefEntry krakenEntry = this.krakenFactory.buildUniRefEntry(this.databaseType);
        krakenEntry.setUniRefEntryId(this.krakenFactory.buildUniRefEntryId(jaxbEntry.getId()));
        krakenEntry.setName(this.krakenFactory.buildUniRefEntryName(jaxbEntry.getName()));
        Date updated = XMLGregorianCalendarConverter.asDate(jaxbEntry.getUpdated());
        krakenEntry.setUpdate(updated);
        krakenEntry.setRepresentativeMember(this.representativeMemberHandler.fromXmlBinding(jaxbEntry.getRepresentativeMember()));
        krakenEntry.setMembers(jaxbEntry.getMember().stream().map(this.memberHandler::fromXmlBinding).collect(Collectors.toList()));
        return krakenEntry;
    }

    @Override
    public Entry toXmlBinding(UniRefEntry entry) {
        Entry jaxbEntry = this.jaxbFactory.createEntry();
        jaxbEntry.setId(entry.getUniRefEntryId().getValue());
        jaxbEntry.setName(entry.getName().getValue());
        jaxbEntry.setRepresentativeMember(this.representativeMemberHandler.toXmlBinding(entry.getRepresentativeMember()));
        XMLGregorianCalendar releaseDate = XMLGregorianCalendarConverter.asXMLGregorianCalendar(entry.getUpdate());
        jaxbEntry.setUpdated(releaseDate);
        entry.getMembers().stream().map(this.memberHandler::toXmlBinding).forEach(jaxbEntry.getMember()::add);
        return jaxbEntry;
    }
}

