/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.evidence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class EvidenceReferenceHandler {
    private final EvidenceFactory evidenceFactory = DefaultUniProtFactory.getInstance().buildEvidenceFactory();
    private Map<EvidenceId, Integer> idMap = new HashMap<EvidenceId, Integer>();
    private Map<String, Integer> idValueMap = new HashMap<String, Integer>();

    public EvidenceReferenceHandler() {
    }

    public EvidenceReferenceHandler(List<String> evidenceIdToIndex) {
        int index = 0;
        for (String ev : evidenceIdToIndex) {
            EvidenceId evId = this.evidenceFactory.buildEvidenceId(ev);
            this.idMap.put(evId, ++index);
            this.idValueMap.put(ev, index);
        }
    }

    public void reset(Map<EvidenceId, Integer> idMap) {
        this.idMap.clear();
        this.idMap.putAll(idMap);
        this.idValueMap.clear();
        for (Map.Entry<EvidenceId, Integer> entry : idMap.entrySet()) {
            this.idValueMap.put(entry.getKey().getValue(), entry.getValue());
        }
    }

    public Integer getIndexForEvidenceId(String evidenceId) {
        return this.idValueMap.get(evidenceId);
    }

    public String getEvidenceIdForIndex(Integer evidenceIndex) {
        for (Map.Entry<String, Integer> entry : this.idValueMap.entrySet()) {
            if (!entry.getValue().equals(evidenceIndex)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Evidence index is not available");
    }

    public EvidenceId getEvidenceIdForIndex2(Integer evidenceIndex) {
        for (Map.Entry<EvidenceId, Integer> entry : this.idMap.entrySet()) {
            if (!entry.getValue().equals(evidenceIndex)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Evidence index is not available");
    }

    public List<Integer> writeEvidenceIDs(List<EvidenceId> evidenceIds) {
        ArrayList<Integer> evidences = new ArrayList<Integer>();
        for (EvidenceId evidenceId : evidenceIds) {
            Integer evId = this.idMap.get(evidenceId);
            if (evId != null) {
                evidences.add(evId);
                continue;
            }
            int ev1 = this.getIndexForEvidenceId(evidenceId.getValue());
            if (ev1 != -1) {
                evidences.add(ev1);
                continue;
            }
            throw new IllegalArgumentException("The evidence reference does not contain an old reference format: " + evidenceId.toString());
        }
        return evidences;
    }

    public List<EvidenceId> parseEvidenceIDs(List<Integer> evidences) {
        ArrayList<EvidenceId> evidenceIds = new ArrayList<EvidenceId>();
        if (evidences != null && !evidences.isEmpty()) {
            for (Map.Entry<EvidenceId, Integer> entry : this.idMap.entrySet()) {
                for (Integer evidence : evidences) {
                    if (!entry.getValue().equals(evidence)) continue;
                    evidenceIds.add(entry.getKey());
                }
            }
        }
        return evidenceIds;
    }
}

