/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class EcNumberHandler {
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private List<DbReferenceType> dbRefTypeList = new ArrayList<DbReferenceType>();

    public EcNumberHandler(ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = evidenceReferenceHandler;
    }

    public void add(Field field) {
        List<Integer> evs;
        DbReferenceType xmlDbRef = this.objectFactory.createDbReferenceType();
        xmlDbRef.setId(field.getValue());
        xmlDbRef.setType("EC");
        if (!field.getEvidenceIds().isEmpty() && !(evs = this.evidenceReferenceHandler.writeEvidenceIDs(field.getEvidenceIds())).isEmpty()) {
            xmlDbRef.getEvidence().addAll(evs);
        }
        this.populateDBRefs(xmlDbRef);
    }

    public List<DbReferenceType> getDbRefTypeList() {
        return this.dbRefTypeList;
    }

    private boolean containsEC(DbReferenceType dbRef) {
        if (!this.dbRefTypeList.isEmpty()) {
            for (DbReferenceType ref : this.dbRefTypeList) {
                if (!ref.getId().equals(dbRef.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private void populateDBRefs(DbReferenceType dbRef) {
        if (this.containsEC(dbRef)) {
            for (DbReferenceType ref : this.dbRefTypeList) {
                if (!ref.getId().equals(dbRef.getId()) || dbRef.getEvidence().isEmpty()) continue;
                List<Integer> differences = this.diffList(ref.getEvidence(), dbRef.getEvidence());
                ref.getEvidence().addAll(differences);
            }
        } else {
            this.dbRefTypeList.add(dbRef);
        }
    }

    private List<Integer> diffList(List<Integer> list1, List<Integer> list2) {
        ArrayList<Integer> result = new ArrayList<Integer>(list2);
        result.removeAll(list1);
        return result;
    }
}

