/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.EcNumberHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericXmlName;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class AlternativeNameHandler
extends GenericNameHandler<ProteinType.AlternativeName, Name> {
    public AlternativeNameHandler(ObjectFactory objectFactory, UniProtFactory factory, EvidenceReferenceHandler evidenceReferenceHandler, EcNumberHandler ecNumberHandler) {
        super(objectFactory, factory, evidenceReferenceHandler, ecNumberHandler);
    }

    @Override
    public ProteinType.AlternativeName toXmlName(Name name) {
        GenericXmlName xmlName = this.populateXmlName(name);
        return this.convertGenericToAlternativeName(xmlName);
    }

    @Override
    public Name fromXmlName(ProteinType.AlternativeName altXmlName) {
        GenericXmlName xmlName = this.convertAlternativeToGenericName(altXmlName);
        if (xmlName != null) {
            Name altName = this.populateName(xmlName);
            altName.setNameType(NameType.ALTNAME);
            return altName;
        }
        return null;
    }

    private ProteinType.AlternativeName convertGenericToAlternativeName(GenericXmlName xmlName) {
        if (xmlName != null) {
            List<EvidencedStringType> ecNumberList;
            List<EvidencedStringType> shortNameList;
            boolean touched = false;
            ProteinType.AlternativeName altName = this.objectFactory.createProteinTypeAlternativeName();
            EvidencedStringType fullName = xmlName.getFullName();
            if (fullName != null) {
                altName.setFullName(fullName);
                touched = true;
            }
            if (!(shortNameList = xmlName.getShortNameList()).isEmpty()) {
                altName.getShortName().addAll(shortNameList);
                touched = true;
            }
            if (!(ecNumberList = xmlName.getEcNumberList()).isEmpty()) {
                altName.getEcNumber().addAll(ecNumberList);
                touched = true;
            }
            return touched ? altName : null;
        }
        return null;
    }

    private GenericXmlName convertAlternativeToGenericName(ProteinType.AlternativeName altXmlName) {
        if (altXmlName != null) {
            List<EvidencedStringType> ecNumberList;
            List<EvidencedStringType> shortNameList;
            boolean touched = false;
            GenericXmlName genericXmlName = new GenericXmlName();
            EvidencedStringType fullName = altXmlName.getFullName();
            if (fullName != null) {
                genericXmlName.setFullName(fullName);
                touched = true;
            }
            if (!(shortNameList = altXmlName.getShortName()).isEmpty()) {
                genericXmlName.setShortNameList(shortNameList);
                touched = true;
            }
            if (!(ecNumberList = altXmlName.getEcNumber()).isEmpty()) {
                genericXmlName.setEcNumberList(ecNumberList);
                touched = true;
            }
            return touched ? genericXmlName : null;
        }
        return null;
    }
}

