/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionType;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class SequenceCautionHandler
implements GenericHandler<SequenceCautionComment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final GenericHandler<String, CommentType.Conflict> conflictHandler;

    public SequenceCautionHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evReferenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = evReferenceHandler;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setCommentFactory(commentFactory);
        itemFactory.setEvidenceReferenceHandler(evReferenceHandler);
        this.conflictHandler = itemFactory.buildSequenceCautionConflictHandler();
    }

    @Override
    public SequenceCautionComment fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML) {
        if (commentXML != null) {
            CommentType.Conflict conflict;
            SequenceCautionComment sequenceCaution = (SequenceCautionComment)this.commentFactory.buildComment(CommentType.SEQUENCE_CAUTION);
            if (commentXML.getMolecule() != null) {
                sequenceCaution.setMolecule(commentXML.getMolecule().getValue());
            }
            if ((conflict = commentXML.getConflict()) != null) {
                sequenceCaution.setSequence(this.conflictHandler.fromXmlBinding(commentXML.getConflict()));
            }
            if (commentXML.getConflict() != null) {
                sequenceCaution.setType(SequenceCautionType.typeOf(commentXML.getConflict().getType()));
            }
            if (!commentXML.getText().isEmpty()) {
                SequenceCautionCommentNote note = this.commentFactory.buildSequenceCautionCommentNote();
                String text = commentXML.getText().get(0).getValue();
                if (text.endsWith(".")) {
                    note.setValue(text.substring(0, text.length() - 1));
                } else {
                    note.setValue(commentXML.getText().get(0).getValue());
                }
                sequenceCaution.setNote(note);
            }
            if (!commentXML.getEvidence().isEmpty()) {
                sequenceCaution.getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(commentXML.getEvidence()));
            }
            return sequenceCaution;
        }
        return null;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(SequenceCautionComment comment) {
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML = this.objectFactory.createCommentType();
        if (comment != null) {
            if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
                MoleculeType mol = this.objectFactory.createMoleculeType();
                mol.setValue(comment.getMolecule());
                commentXML.setMolecule(mol);
            }
            if (comment.getSequence() != null) {
                commentXML.setConflict(this.conflictHandler.toXmlBinding(comment.getSequence()));
            }
            if (comment.getType() != null) {
                commentXML.getConflict().setType(comment.getType().toDisplayName().toLowerCase());
            }
            if (comment.getNote() != null && !comment.getNote().getValue().trim().isEmpty()) {
                EvidencedStringType text = this.objectFactory.createEvidencedStringType();
                String note = comment.getNote().getValue();
                if (!note.endsWith(".")) {
                    note = note + ".";
                }
                text.setValue(note);
                commentXML.getText().add(text);
            }
            if (!comment.getEvidenceIds().isEmpty()) {
                commentXML.getEvidence().addAll(this.evidenceReferenceHandler.writeEvidenceIDs(comment.getEvidenceIds()));
            }
            return commentXML;
        }
        return null;
    }
}

