/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class BPCPropertiesHandler
implements GenericHandler<BioPhysicoChemicalPropertiesComment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final GenericHandler<Absorption, CommentType.Absorption> absorptionHandler;
    private final GenericHandler<KineticParameters, CommentType.Kinetics> kineticParamsHandler;
    private final GenericHandler<PHDependence, CommentType.PhDependence> phDependenceHandler;
    private final GenericHandler<RedoxPotential, CommentType.RedoxPotential> redoxPotentialHandler;
    private final GenericHandler<TemperatureDependence, CommentType.TemperatureDependence> tempDependenceHandler;

    public BPCPropertiesHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setCommentFactory(commentFactory);
        itemFactory.setEvidenceReferenceHandler(referenceHandler);
        this.absorptionHandler = itemFactory.buildAbsorptionHandler();
        this.kineticParamsHandler = itemFactory.buildKineticParametersHandler();
        this.phDependenceHandler = itemFactory.buildPHDependenceHandler();
        this.redoxPotentialHandler = itemFactory.buildRedoxPotentialHandler();
        this.tempDependenceHandler = itemFactory.buildTemperatureDependenceHandler();
    }

    @Override
    public BioPhysicoChemicalPropertiesComment fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML) {
        BioPhysicoChemicalPropertiesComment comment = (BioPhysicoChemicalPropertiesComment)this.commentFactory.buildComment(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES);
        if (commentXML != null) {
            if (commentXML.getMolecule() != null) {
                comment.setMolecule(commentXML.getMolecule().getValue());
            }
            if (commentXML.getAbsorption() != null) {
                comment.setAbsorption(this.absorptionHandler.fromXmlBinding(commentXML.getAbsorption()));
            }
            if (commentXML.getPhDependence() != null) {
                comment.setPHDepencence(this.phDependenceHandler.fromXmlBinding(commentXML.getPhDependence()));
            }
            if (commentXML.getRedoxPotential() != null) {
                comment.setRedoxPotential(this.redoxPotentialHandler.fromXmlBinding(commentXML.getRedoxPotential()));
            }
            if (commentXML.getTemperatureDependence() != null) {
                comment.setTemperatureDependence(this.tempDependenceHandler.fromXmlBinding(commentXML.getTemperatureDependence()));
            }
            if (commentXML.getKinetics() != null) {
                comment.setKineticParameters(this.kineticParamsHandler.fromXmlBinding(commentXML.getKinetics()));
            }
            return comment;
        }
        return null;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(BioPhysicoChemicalPropertiesComment comment) {
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML = this.objectFactory.createCommentType();
        if (comment != null) {
            if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
                MoleculeType mol = this.objectFactory.createMoleculeType();
                mol.setValue(comment.getMolecule());
                commentXML.setMolecule(mol);
            }
            if (comment.getAbsorption().getMax() != 0) {
                commentXML.setAbsorption(this.absorptionHandler.toXmlBinding(comment.getAbsorption()));
            }
            commentXML.setPhDependence(this.phDependenceHandler.toXmlBinding(comment.getPHDependence()));
            commentXML.setRedoxPotential(this.redoxPotentialHandler.toXmlBinding(comment.getRedoxPotential()));
            commentXML.setTemperatureDependence(this.tempDependenceHandler.toXmlBinding(comment.getTemperatureDependence()));
            if (!(comment.getKineticParameters().getMichaelisConstants().isEmpty() && comment.getKineticParameters().getMaximumVelocities().isEmpty() && comment.getKineticParameters().getNote().getTexts().isEmpty())) {
                commentXML.setKinetics(this.kineticParamsHandler.toXmlBinding(comment.getKineticParameters()));
            }
            return commentXML;
        }
        return null;
    }
}

