/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.common;

import java.text.ParseException;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PublicationDate;
import uk.ac.ebi.kraken.parser.util.PublicationDateFormatter;
import uk.ac.ebi.kraken.xml.common.GenericHandler;

public class PublicationDateHandler
implements GenericHandler<PublicationDate, String> {
    private static final Logger logger = LoggerFactory.getLogger(PublicationDateHandler.class);
    private static final Pattern HYPHEN = Pattern.compile("-");
    private final CitationNewFactory citationFactory;

    public PublicationDateHandler(CitationNewFactory citationFactory) {
        this.citationFactory = citationFactory;
    }

    @Override
    public PublicationDate fromXmlBinding(String xmlDate) {
        if (xmlDate != null && xmlDate.length() > 0) {
            try {
                if (PublicationDateFormatter.DAY_DIGITMONTH_YEAR.isValidDate(xmlDate)) {
                    Date date = PublicationDateFormatter.DAY_DIGITMONTH_YEAR.convertStringToDate(xmlDate);
                    String newDate = PublicationDateFormatter.DAY_THREE_LETTER_MONTH_YEAR.convertDateToString(date);
                    return this.citationFactory.buildPublicationDate(newDate.toUpperCase());
                }
                if (PublicationDateFormatter.YEAR_DIGIT_MONTH.isValidDate(xmlDate)) {
                    Date date = PublicationDateFormatter.YEAR_DIGIT_MONTH.convertStringToDate(xmlDate);
                    String newDate = PublicationDateFormatter.THREE_LETTER_MONTH_YEAR.convertDateToString(date);
                    return this.citationFactory.buildPublicationDate(newDate.toUpperCase());
                }
            }
            catch (ParseException e) {
                logger.error("Error in citation. Origin of error [" + e.getMessage() + ']');
            }
            return this.citationFactory.buildPublicationDate(xmlDate.toUpperCase());
        }
        return this.citationFactory.buildPublicationDate("0");
    }

    @Override
    public String toXmlBinding(PublicationDate citation) {
        block9: {
            if (citation.getValue() != null && citation.getValue().trim().length() > 0) {
                String pubDate = citation.getValue();
                try {
                    if ("0".equals(pubDate.trim())) break block9;
                    int numOfDateValues = HYPHEN.split(pubDate).length;
                    if (numOfDateValues == 3) {
                        if (PublicationDateFormatter.DAY_THREE_LETTER_MONTH_YEAR.isValidDate(pubDate)) {
                            Date date = PublicationDateFormatter.DAY_THREE_LETTER_MONTH_YEAR.convertStringToDate(pubDate);
                            return PublicationDateFormatter.DAY_DIGITMONTH_YEAR.convertDateToString(date);
                        }
                        if (PublicationDateFormatter.DAY_DIGITMONTH_YEAR.isValidDate(pubDate)) {
                            Date date = PublicationDateFormatter.DAY_DIGITMONTH_YEAR.convertStringToDate(pubDate);
                            return PublicationDateFormatter.DAY_DIGITMONTH_YEAR.convertDateToString(date);
                        }
                        break block9;
                    }
                    if (numOfDateValues == 2) {
                        if (PublicationDateFormatter.YEAR_DIGIT_MONTH.isValidDate(pubDate)) {
                            Date date = PublicationDateFormatter.YEAR_DIGIT_MONTH.convertStringToDate(pubDate);
                            return PublicationDateFormatter.YEAR_DIGIT_MONTH.convertDateToString(date);
                        }
                        if (PublicationDateFormatter.THREE_LETTER_MONTH_YEAR.isValidDate(pubDate)) {
                            Date date = PublicationDateFormatter.THREE_LETTER_MONTH_YEAR.convertStringToDate(pubDate);
                            return PublicationDateFormatter.YEAR_DIGIT_MONTH.convertDateToString(date);
                        }
                        break block9;
                    }
                    Date date = PublicationDateFormatter.YEAR.convertStringToDate(pubDate);
                    return PublicationDateFormatter.YEAR.convertDateToString(date);
                }
                catch (ParseException e) {
                    logger.error("Error in citation. Origin of error [" + e.getMessage() + ']');
                }
            }
        }
        return null;
    }
}

