/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations;

import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CitationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReferenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;
import uk.ac.ebi.kraken.xml.uniprot.citations.CitationItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class SubmissionHandler
implements GenericHandler<Submission, ReferenceType> {
    private final ObjectFactory objectFactory;
    private final CitationNewFactory citationFactory;
    private final GenericHandler<SubmissionDatabase, String> submissionDatabaseHandler;
    private final GenericUpdater<Citation, ReferenceType> commonReferenceUpdater;

    public SubmissionHandler(ObjectFactory objectFactory, CitationNewFactory citationFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.objectFactory = objectFactory;
        this.citationFactory = citationFactory;
        CitationItemFactory itemFactory = new CitationItemFactory();
        itemFactory.setCitationFactory(citationFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setReferenceHandler(evidenceReferenceHandler);
        this.submissionDatabaseHandler = new SubmissionDatabaseHandler();
        this.commonReferenceUpdater = itemFactory.buildCommonReferenceUpdater();
    }

    @Override
    public Submission fromXmlBinding(ReferenceType referenceXML) {
        if (referenceXML != null) {
            Submission citation = this.citationFactory.buildSubmission();
            CitationType citationXML = referenceXML.getCitation();
            if (citationXML == null) {
                return null;
            }
            SubmissionDatabase submissionDatabase = this.submissionDatabaseHandler.fromXmlBinding(citationXML.getDb());
            if (submissionDatabase != null) {
                citation.setSubmittedToDatabase(submissionDatabase);
            }
            this.commonReferenceUpdater.fromXmlBinding(citation, referenceXML);
            return citation;
        }
        return null;
    }

    @Override
    public ReferenceType toXmlBinding(Submission citation) {
        if (citation != null) {
            ReferenceType referenceXML = this.objectFactory.createReferenceType();
            CitationType citationXML = this.objectFactory.createCitationType();
            referenceXML.setCitation(citationXML);
            citationXML.setType("submission");
            citationXML.setDb(this.submissionDatabaseHandler.toXmlBinding(citation.getSubmittedToDatabase()));
            this.commonReferenceUpdater.toXmlBinding(referenceXML, citation);
            return referenceXML;
        }
        return null;
    }

    private class SubmissionDatabaseHandler
    implements GenericHandler<SubmissionDatabase, String> {
        private SubmissionDatabaseHandler() {
        }

        @Override
        public SubmissionDatabase fromXmlBinding(String XML) {
            if (XML != null && XML.length() > 0) {
                return SubmissionDatabase.typeOf(XML);
            }
            return null;
        }

        @Override
        public String toXmlBinding(SubmissionDatabase citation) {
            if (citation.getValue() != null && citation.getValue().trim().length() > 0) {
                return citation.getValue();
            }
            return null;
        }
    }
}

