/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordEntry;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordNotRecognizedException;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordSynonym;
import uk.ac.ebi.kraken.model.factories.DefaultKeywordListFactory;
import uk.ac.ebi.kraken.xml.uniprot.KeywordListConverter;

public class KeywordListHandler {
    private HashMap<String, String> nameToId = new HashMap();
    private HashMap<String, String> idToName = new HashMap();

    public KeywordListHandler(File keywordListFile) throws JAXBException {
        List<KeywordEntry> keywordEntries = this.readEntries(keywordListFile);
        this.initMaps(keywordEntries);
    }

    public String getIdForName(String name) {
        String id = this.nameToId.get(name);
        if (id == null) {
            throw new IllegalArgumentException("Keyword with name \"" + name + "\" does not exist. Please check if keywordlist file is correct");
        }
        return id;
    }

    public String getNameForId(String id) {
        String name = this.idToName.get(id);
        if (name == null) {
            throw new KeywordNotRecognizedException("Keyword with id \"" + id + "\" does not exist. Please check if keywordlist file is correct");
        }
        return name;
    }

    private void initMaps(List<KeywordEntry> entries) {
        for (KeywordEntry keywordEntry : entries) {
            this.nameToId.put(keywordEntry.getIdentifier().getValue(), keywordEntry.getAccession().getValue());
            this.idToName.put(keywordEntry.getAccession().getValue(), keywordEntry.getIdentifier().getValue());
            for (KeywordSynonym synonym : keywordEntry.getSynonyms()) {
                this.nameToId.put(synonym.getValue(), keywordEntry.getAccession().getValue());
            }
        }
    }

    private List<KeywordEntry> readEntries(File keywordListFile) throws JAXBException {
        KeywordListConverter converter = new KeywordListConverter(DefaultKeywordListFactory.getInstance());
        return converter.readKeywordList(keywordListFile);
    }
}

