/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniparc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.kraken.interfaces.factories.EntryFactory;
import uk.ac.ebi.kraken.interfaces.factories.UniParcFactory;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.xml.common.KrakenXMLIterator;
import uk.ac.ebi.kraken.xml.common.XMLParserException;
import uk.ac.ebi.kraken.xml.jaxb.uniparc.Entry;
import uk.ac.ebi.kraken.xml.uniparc.UniParcEntryJAXBConverter;

public class UniParcXMLEntryIterator
extends KrakenXMLIterator<UniParcEntry> {
    private UniParcEntryJAXBConverter entryConverter;
    private final EntryFactory factory;

    public UniParcXMLEntryIterator(UniParcFactory factory, File file) throws IOException {
        super(file);
        this.factory = factory;
    }

    public UniParcXMLEntryIterator(UniParcFactory factory, InputStream inputStream) throws IOException {
        super(inputStream);
        this.factory = factory;
    }

    public UniParcXMLEntryIterator(UniParcFactory factory, Reader reader) throws IOException {
        super(reader);
        this.factory = factory;
    }

    public UniParcXMLEntryIterator(UniParcFactory factory, URL url) throws IOException {
        super(url);
        this.factory = factory;
    }

    @Override
    protected String getNameSpace() {
        return "http://www.uniprot.org/uniparc";
    }

    @Override
    protected String getName() {
        return "uniparc";
    }

    @Override
    protected UniParcEntry convertXMLEntry(Object entry) {
        UniParcEntry uniParcEntry = ((UniParcFactory)this.factory).buildEntry();
        if (this.isXMLEntryType(this.xmlEntry)) {
            Entry xmlEntry = (Entry)entry;
            try {
                this.getEntryConverter().fromJAXB(xmlEntry, uniParcEntry);
            }
            catch (JAXBException e) {
                if (this.isQuiet()) {
                    this.getExceptionBucket().put(xmlEntry.getAccession(), (Exception)((Object)e));
                    if (this.getMaxEntriesInBucket() > this.getExceptionBucket().size()) {
                        throw new XMLParserException("Unable to continue parsing xml file exception bucket is full ", e);
                    }
                }
                System.err.println(e.getMessage());
            }
        }
        return uniParcEntry;
    }

    @Override
    protected boolean isXMLEntryType(Object xmlEntry) {
        return xmlEntry instanceof Entry;
    }

    @Override
    protected void configJAXBContext() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniparc");
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to initialize the JAXBContext");
        }
    }

    private UniParcEntryJAXBConverter getEntryConverter() {
        if (this.entryConverter == null) {
            this.entryConverter = UniParcEntryJAXBConverter.getInstance();
        }
        return this.entryConverter;
    }
}

