/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.test;

import java.util.HashMap;
import java.util.StringTokenizer;

public class UniProtXMLText {
    private String text;
    private HashMap<String, Integer> hierarchy;

    public UniProtXMLText() {
        this.generateDefaultEntryText();
        this.initLineHierarchy();
    }

    private void initLineHierarchy() {
        this.hierarchy = new HashMap();
        this.hierarchy.put("ID", new Integer(0));
        this.hierarchy.put("AC", new Integer(1000));
        this.hierarchy.put("DT", new Integer(2000));
        this.hierarchy.put("DE", new Integer(3000));
        this.hierarchy.put("GN", new Integer(4000));
        this.hierarchy.put("OS", new Integer(5000));
        this.hierarchy.put("OG", new Integer(5500));
        this.hierarchy.put("OC", new Integer(6000));
        this.hierarchy.put("OX", new Integer(7000));
        this.hierarchy.put("RN", new Integer(8000));
        this.hierarchy.put("RA", new Integer(8000));
        this.hierarchy.put("RL", new Integer(8000));
        this.hierarchy.put("RT", new Integer(8000));
        this.hierarchy.put("RC", new Integer(8000));
        this.hierarchy.put("RP", new Integer(8000));
        this.hierarchy.put("RX", new Integer(8000));
        this.hierarchy.put("CC", new Integer(8500));
        this.hierarchy.put("DR", new Integer(9000));
        this.hierarchy.put("FT", new Integer(10000));
        this.hierarchy.put("KW", new Integer(11000));
        this.hierarchy.put("SQ", new Integer(12000));
        this.hierarchy.put("  ", new Integer(13000));
        this.hierarchy.put("//", new Integer(14000));
    }

    private void generateDefaultEntryText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStandardXMLHeader());
        sb.append('\n');
        sb.append(this.getStandardEntryStartTag());
        sb.append('\n');
        sb.append(this.getStandardAccessionTag());
        sb.append('\n');
        sb.append(this.getStandardNameTag());
        sb.append('\n');
        sb.append(this.getStandardProteinTag());
        sb.append('\n');
        sb.append(this.getStandardOrganismStartTag());
        sb.append('\n');
        sb.append(this.getStandardNCBITaxonomyTag());
        sb.append('\n');
        sb.append(this.getStandardLineageTag());
        sb.append('\n');
        sb.append(this.getStandardOrganismEndTag());
        sb.append('\n');
        sb.append(this.getStandardReferenceStartTag());
        sb.append('\n');
        sb.append(this.getStandardCitationTag());
        sb.append('\n');
        sb.append(this.getStandardScopeTag());
        sb.append('\n');
        sb.append(this.getStandardReferenceEndTag());
        sb.append('\n');
        sb.append(this.getStandardSequenceStartTag());
        sb.append('\n');
        sb.append(this.getStandardSequenceData());
        sb.append('\n');
        sb.append(this.getStandardSequenceEndTag());
        sb.append('\n');
        sb.append(this.getStandardEntryEndTag());
        this.text = sb.toString();
    }

    private String getStandardSequenceData() {
        return "MSLKGKLQRMKK";
    }

    public String getText() {
        return this.text;
    }

    public String getStandardXMLHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<uniprot xmlns=\"http://uniprot.org/uniprot\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xsi:schemaLocation=\"http://uniprot.org/uniprot http://www.uniprot.org/docs/uniprot.xsd\">";
    }

    public String getStandardEntryStartTag() {
        return "<entry dataset=\"Swiss-Prot\" created=\"1996-10-01\" modified=\"2005-05-10\">";
    }

    public String getStandardAccessionTag() {
        return "  <accession>P50837</accession>";
    }

    public String getStandardNameTag() {
        return "  <name>YPRB_BACSU</name>";
    }

    public String getStandardProteinTag() {
        return "  <protein>\n    <name>Name</name>\n  </protein>";
    }

    public String getStandardOrganismStartTag() {
        return "  <organism key=\"1\">\n    <name type=\"scientific\">Bacillus subtilis</name>";
    }

    public String getStandardOrganismEndTag() {
        return "  </organism>";
    }

    public String getStandardNCBITaxonomyTag() {
        return "    <dbReference type=\"NCBI Taxonomy\" id=\"1423\" key=\"2\"/>";
    }

    public String getStandardLineageTag() {
        return "     <lineage>\n      <taxon>Bacteria</taxon>\n      <taxon>Firmicutes</taxon>\n      <taxon>Bacillales</taxon>\n      <taxon>Bacillaceae</taxon>\n      <taxon>Bacillus</taxon>\n    </lineage>";
    }

    public String getStandardReferenceStartTag() {
        return "  <reference key=\"3\">";
    }

    public String getStandardReferenceEndTag() {
        return "  </reference>";
    }

    public String getStandardCitationTag() {
        return "    <citation type=\"journal article\" date=\"1996\" name=\"Microbiology\" volume=\"142\" first=\"2005\" last=\"2016\">\n      <title>Sequence analysis of the Bacillus subtilis chromosome region between the serA and kdg loci cloned in a yeast artificial chromosome.</title>\n      <authorList>\n        <person name=\"Sorokin A.V.\"/>\n      </authorList>\n      <dbReference type=\"PubMed\" id=\"8760912\" key=\"4\"/>\n      <dbReference type=\"MEDLINE\" id=\"96349105\" key=\"5\"/>\n    </citation>";
    }

    public String getStandardScopeTag() {
        return "    <scope>NUCLEOTIDE SEQUENCE.</scope>";
    }

    public String getStandardSequenceStartTag() {
        return "  <sequence length=\"413\" mass=\"47995\" checksum=\"C9A713A7140A5339\" modified=\"1996-10-01\">";
    }

    public String getStandardSequenceEndTag() {
        return "  </sequence>";
    }

    public String getStandardEntryEndTag() {
        return "  </entry>\n</uniprot>";
    }

    public void setACLine(String acLine) {
        this.setLine(acLine, "<accession>", 1);
    }

    public void setGNLine(String gnLine) {
        this.setLine(gnLine, "<name>", 1);
    }

    public void setDTLine(String dtLine) {
        this.setLine(dtLine, "<entry", 1);
    }

    public void setDELine(String deLine) {
        this.setLine(deLine, "<protein ", 1);
    }

    public void setOSLine(String osLine) {
        this.setLine(osLine, "<organism ", 1);
    }

    public void setReferences(String ref) {
        this.setLine(ref, "<reference", 1);
    }

    public void setDatabaseXRef(String ref) {
        if (ref.endsWith("</dbReference>")) {
            ref = ref.substring(0, ref.indexOf("</dbReference>"));
        }
        this.setLine(ref, "<dbReference", 3);
    }

    private boolean setLine(String newLine, String token, int index) {
        boolean wasReplaced = false;
        StringTokenizer st = new StringTokenizer(this.text, "\n");
        StringBuilder newText = new StringBuilder();
        int counter = 0;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.trim().startsWith(token)) {
                if (!wasReplaced && ++counter == index) {
                    newText.append(newLine);
                    newText.append("\n");
                    wasReplaced = true;
                    continue;
                }
                newText.append(line);
                newText.append("\n");
                continue;
            }
            newText.append(line);
            newText.append("\n");
        }
        this.text = newText.toString();
        return wasReplaced;
    }
}

