/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.fasta;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastaReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FastaReader.class);
    private final File file;
    private BufferedReader fileReader;
    private String currentLine;
    private int currentNumberOfSequences;

    public FastaReader(String fileName) {
        this.file = new File(fileName);
    }

    public FastaReader(File file) {
        this.file = file;
    }

    @Override
    public void close() {
        if (this.fileReader != null) {
            try {
                this.fileReader.close();
            }
            catch (IOException e) {
                LOG.error("Cannot close fastq file reader", (Throwable)e);
            }
        }
    }

    public Sequence nextSequence() {
        if (this.currentLine == null) {
            LOG.debug("There is no more sequence in the fasta file");
            return null;
        }
        if (this.currentLine.startsWith(">")) {
            String name = this.currentLine.substring(1);
            StringBuilder seqBuilder = new StringBuilder();
            do {
                try {
                    this.currentLine = this.fileReader.readLine();
                    if (this.currentLine == null || this.currentLine.startsWith(">")) continue;
                    seqBuilder.append(this.currentLine);
                }
                catch (IOException e) {
                    LOG.error("Problems to read fasta file", (Throwable)e);
                }
            } while (this.currentLine != null && !this.currentLine.startsWith(">"));
            ++this.currentNumberOfSequences;
            String seq = seqBuilder.toString();
            return new Sequence(name, seq);
        }
        LOG.error("The forma of fasta file is wrong");
        return null;
    }

    public void openInputFile() throws IOException {
        String fileName = this.file.getPath();
        if (!this.file.exists()) {
            throw new FileNotFoundException("File does not exist: " + fileName);
        }
        if (this.file.isDirectory()) {
            throw new IllegalArgumentException("File name is a directory: " + fileName);
        }
        if (!this.file.canRead()) {
            throw new FileNotFoundException("File cannot be read: " + fileName);
        }
        this.fileReader = new BufferedReader(new FileReader(this.file));
        this.currentLine = this.fileReader.readLine();
    }

    public int getCurrentNumberOfSequences() {
        return this.currentNumberOfSequences;
    }

    public BufferedReader getFileReader() {
        return this.fileReader;
    }

    public static class Sequence {
        public String name;
        public String seq;

        public Sequence(String name, String seq) {
            this.name = name;
            this.seq = seq;
        }

        public int getSeqLength() {
            return this.seq.length();
        }

        public String getMd5() {
            MessageDigest complete;
            StringBuilder result = new StringBuilder();
            try {
                complete = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("Problems to calculate md5", (Throwable)e);
                return null;
            }
            complete.update(this.seq.getBytes());
            byte[] b = complete.digest();
            for (int i = 0; i < b.length; ++i) {
                result.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
            return result.toString();
        }

        public Map<Character, Integer> getAAComposition() {
            HashMap<Character, Integer> aaComposition = new HashMap<Character, Integer>();
            for (char aa : this.seq.toUpperCase().toCharArray()) {
                if (aa == '*') continue;
                Integer freq = aaComposition.get(Character.valueOf(aa));
                if (freq == null) {
                    aaComposition.put(Character.valueOf(aa), 1);
                    continue;
                }
                aaComposition.put(Character.valueOf(aa), freq + 1);
            }
            return aaComposition;
        }
    }
}

