/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class SubcellularLocationCommentTranslater
implements CommentTranslator<SubcellularLocationComment> {
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.SUBCELLULAR_LOCATION;

    @Override
    public SubcellularLocationComment translate(String annotation) {
        SubcellularLocationComment comment = (SubcellularLocationComment)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    @Override
    public void translate(String annotation, SubcellularLocationComment comment) {
        String preNote;
        if (annotation == null) {
            return;
        }
        if (annotation.contains("Note=")) {
            String[] splitByNote = annotation.split("Note=");
            if (splitByNote.length > 1) {
                preNote = splitByNote[0].trim();
                String noteStr = splitByNote[1].trim();
                SubcellularLocationNote note = FACTORY.buildSubcellularLocationNote();
                note.setTexts(CommentTranslatorHelper.parseEvidencedValues(noteStr, true, '.'));
                comment.setSubcellularLocationNote(note);
            } else {
                preNote = annotation;
            }
        } else {
            preNote = annotation;
        }
        int moleculeEndIndex = preNote.indexOf(": ");
        if (moleculeEndIndex > -1) {
            String molecule = preNote.substring(1, moleculeEndIndex - 1);
            comment.setMolecule(molecule);
            preNote = preNote.substring(moleculeEndIndex + 1).trim();
        }
        List<SubcellularLocation> locations = this.populateLocations(preNote);
        comment.setSubcellularLocations(locations);
    }

    private List<SubcellularLocation> populateLocations(String preNote) {
        String[] strings;
        ArrayList<SubcellularLocation> locations = new ArrayList<SubcellularLocation>();
        for (String aSubcellularLocation : strings = preNote.split("\\. ")) {
            if (aSubcellularLocation.trim().length() == 0) continue;
            SubcellularLocation location = DefaultCommentFactory.getInstance().buildSubcellularLocation();
            this.populateLocation(aSubcellularLocation, location);
            locations.add(location);
        }
        return Collections.unmodifiableList(locations);
    }

    private void populateLocation(String subcellularLocationsStrings, SubcellularLocation location) {
        String[] locationElements = subcellularLocationsStrings.split(";");
        location.setLocation(this.populateValue(locationElements[0]));
        if (locationElements.length == 2) {
            location.setTopology(this.populateValue(locationElements[1]));
        }
        if (locationElements.length == 3) {
            location.setTopology(this.populateValue(locationElements[1]));
            location.setOrientation(this.populateValue(locationElements[2]));
        }
    }

    private SubcellularLocationValue populateValue(String value) {
        SubcellularLocationValue valueToPopulate = DefaultCommentFactory.getInstance().buildSubcellularLocationValue();
        value = CommentTranslatorHelper.stripTrailing(value, ".").trim();
        ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
        value = CommentTranslatorHelper.stripEvidenceIds(value, evidences);
        value = CommentTranslatorHelper.stripTrailing(value, ".");
        value = CommentTranslatorHelper.setCommentStatus(value, valueToPopulate);
        valueToPopulate.setValue(value);
        valueToPopulate.setEvidenceIds(evidences);
        return valueToPopulate;
    }
}

