/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryMethod;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRange;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class MassSpectrometryCommentTranslator
implements CommentTranslator<MassSpectrometryComment> {
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.MASS_SPECTROMETRY;

    @Override
    public MassSpectrometryComment translate(String annotation) {
        MassSpectrometryComment comment = (MassSpectrometryComment)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    private String updateMolecule(String annotation, MassSpectrometryComment comment) {
        if (annotation.startsWith("[") && annotation.contains("]")) {
            int index = annotation.indexOf("]");
            String molecule = annotation.substring(1, index);
            molecule = molecule.replaceAll("\n", " ");
            comment.setMolecule(molecule);
            annotation = annotation.substring(index + 2).trim();
            if (annotation.startsWith("\n")) {
                annotation = annotation.substring(1);
            }
            return annotation;
        }
        return annotation;
    }

    @Override
    public void translate(String annotation, MassSpectrometryComment comment) {
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        annotation = CommentTranslatorHelper.stripTrailing(annotation, ".");
        annotation = this.updateMolecule(annotation, comment);
        StringBuilder com = new StringBuilder();
        for (int iii = 0; iii < annotation.length(); ++iii) {
            String follow;
            char c = annotation.charAt(iii);
            if (c == ';' && ((follow = annotation.substring(iii + 1)).startsWith(" Mass=") || follow.startsWith(" Note=") || follow.startsWith(" Source=") || follow.startsWith(" Mass_error=") || follow.startsWith(" Range=") || follow.startsWith(" Method=") || follow.startsWith(" Evidence="))) {
                com.append('\u1000');
                continue;
            }
            com.append(c);
        }
        annotation = com.toString();
        annotation = CommentTranslatorHelper.stripTrailing(annotation, ".");
        annotation = CommentTranslatorHelper.stripTrailing(annotation, ";");
        StringTokenizer st = new StringTokenizer(annotation, "\u1000");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int indexEq = token.indexOf(61);
            if (indexEq > -1) {
                if (indexEq < token.length() - 1) {
                    if (token.startsWith("Mass_error")) {
                        String mWERR = token.substring(indexEq + 1, token.length());
                        if (mWERR.length() <= 0) continue;
                        comment.setMolWeightError(Float.parseFloat(mWERR));
                        continue;
                    }
                    if (token.startsWith("Mass")) {
                        String mw = token.substring(indexEq + 1, token.length());
                        comment.setMolWeight(Float.parseFloat(mw));
                        continue;
                    }
                    if (token.startsWith("Note")) {
                        String note = token.substring(indexEq + 1, token.length());
                        comment.setNote(DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryCommentNote(note));
                        continue;
                    }
                    if (token.startsWith("Evidence")) {
                        String evidenceStr = token.substring(indexEq + 1, token.length());
                        if (evidenceStr.length() <= 0) continue;
                        ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                        CommentTranslatorHelper.stripEvidenceIds(evidenceStr, evidences);
                        comment.setEvidenceIds(evidences);
                        ArrayList<MassSpectrometryCommentSource> list = new ArrayList<MassSpectrometryCommentSource>();
                        for (EvidenceId evId : evidences) {
                            list.add(FACTORY.buildMassSpectrometryCommentSource(evId.getValue()));
                        }
                        comment.setSources(list);
                        continue;
                    }
                    if (token.startsWith("Method")) {
                        String method = token.substring(indexEq + 1, token.length());
                        if (method.length() <= 0) continue;
                        comment.setMethod(MassSpectrometryMethod.toType(method));
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown element " + token + " found in MASS SPECTROMETRY comment " + annotation);
                }
                throw new IllegalArgumentException("Missing value at token " + token + " found in MASS SPECTROMETRY comment " + annotation);
            }
            throw new IllegalArgumentException("Missing \"=\" in token " + token + " within line " + annotation);
        }
    }

    private List<MassSpectrometryRange> getMassSpecRanges(String range) {
        StringTokenizer dashTokenizer = new StringTokenizer(range, ",");
        StringBuilder leftOvers = new StringBuilder();
        boolean openStatement = false;
        ArrayList<MassSpectrometryRange> massSpecRanges = new ArrayList<MassSpectrometryRange>();
        MassSpectrometryRange newRange = DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryRange();
        while (dashTokenizer.hasMoreTokens()) {
            String token = dashTokenizer.nextToken();
            if (openStatement) {
                String restToken = leftOvers.toString() + "," + token;
                int indexLastRightBracket = restToken.lastIndexOf(41);
                if (indexLastRightBracket > -1) {
                    newRange.setIsoformId(DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryIsoformId(restToken.substring(0, indexLastRightBracket).trim()));
                    massSpecRanges.add(newRange);
                    newRange = DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryRange();
                    leftOvers = new StringBuilder();
                    token = restToken.substring(indexLastRightBracket + 1);
                    openStatement = false;
                }
                if (token.length() < 1) continue;
            }
            int indexDash = token.indexOf(45);
            int indexLeftBracket = token.indexOf(40);
            int indexLastRightBracket = token.lastIndexOf(41);
            if (!openStatement && indexDash > -1) {
                newRange.setStart(this.parseRangeNumber(token.substring(0, indexDash)));
                if (indexLeftBracket > -1) {
                    newRange.setEnd(this.parseRangeNumber(token.substring(indexDash + 1, indexLeftBracket)));
                    if (indexLastRightBracket > -1) {
                        newRange.setIsoformId(DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryIsoformId(token.substring(indexLeftBracket + 1, indexLastRightBracket).trim()));
                        openStatement = false;
                    } else {
                        leftOvers.append(token.substring(indexLeftBracket + 1));
                        openStatement = true;
                    }
                } else {
                    newRange.setEnd(this.parseRangeNumber(token.substring(indexDash + 1)));
                }
                if (openStatement) continue;
                massSpecRanges.add(newRange);
                newRange = DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryRange();
                leftOvers = new StringBuilder();
                continue;
            }
            leftOvers.append(",");
            leftOvers.append(token);
            openStatement = true;
        }
        return massSpecRanges;
    }

    private int parseRangeNumber(String numberOrUnknown) {
        int numberOrUnknownLength = (numberOrUnknown = numberOrUnknown.trim()).length();
        if (numberOrUnknownLength < 1) {
            throw new IllegalArgumentException("Missing position in mass spectrometry range.");
        }
        return numberOrUnknownLength == 1 && numberOrUnknown.charAt(0) == '?' ? -1 : Integer.parseInt(numberOrUnknown);
    }
}

