/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseAcronym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class DiseaseCommentTranslator
implements CommentTranslator<DiseaseCommentStructured> {
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.DISEASE;
    private static final Pattern BETWEEN_PARENTHESIS_PATTERN = Pattern.compile("\\((.*?)\\) \\[MIM:");
    private static final Pattern BETWEEN_SQUARE_BRACKETS_PATTERN = Pattern.compile("\\[(.*\\:.*?)\\]");

    @Override
    public DiseaseCommentStructured translate(String annotation) {
        DiseaseCommentStructured comment = (DiseaseCommentStructured)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    @Override
    public void translate(String annotation, DiseaseCommentStructured comment) {
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        annotation = this.updateMolecule(annotation, comment);
        String[] splitByNote = annotation.split("Note=");
        comment.setDisease(this.populateDisease(splitByNote[0].trim()));
        if (splitByNote.length == 2) {
            DiseaseNote note = DefaultCommentFactory.getInstance().buildDiseaseNote();
            String noteValue = splitByNote[1].trim();
            note.setTexts(CommentTranslatorHelper.parseEvidencedValues(noteValue, true));
            comment.setNote(note);
        }
    }

    private String updateMolecule(String annotation, DiseaseCommentStructured comment) {
        if (annotation.startsWith("[") && annotation.contains("]")) {
            int index = annotation.indexOf("]");
            String molecule = annotation.substring(1, index);
            molecule = molecule.replaceAll("\n", " ");
            comment.setMolecule(molecule);
            annotation = annotation.substring(index + 2).trim();
            if (annotation.startsWith("\n")) {
                annotation = annotation.substring(1);
            }
            return annotation;
        }
        return annotation;
    }

    private Disease populateDisease(String diseaseString) {
        Disease disease = DefaultCommentFactory.getInstance().buildDisease();
        String sep = "[MIM:";
        String sep2 = "]:";
        if (diseaseString.length() > 0) {
            int index = diseaseString.indexOf(sep);
            int index2 = diseaseString.indexOf(sep2);
            String firstPart = diseaseString;
            String description = diseaseString;
            if (index != -1 && index2 != -1) {
                firstPart = diseaseString.substring(0, index2 + 2);
                description = diseaseString.substring(index2 + 2).trim();
            }
            disease.setDiseaseId(this.populateDiseaseId(firstPart));
            disease.setDiseaseAcronym(this.populateDiseaseAcronym(firstPart));
            disease.setDiseaseReference(this.populateDiseaseReference(firstPart));
            disease.setDiseaseDescription(this.populateDiseaseDescription(description));
        }
        return disease;
    }

    private DiseaseId populateDiseaseId(String diseaseString) {
        DiseaseId id = FACTORY.buildDiseaseId();
        String idString = diseaseString.substring(0, diseaseString.indexOf(40)).trim();
        id.setValue(idString);
        return id;
    }

    private DiseaseAcronym populateDiseaseAcronym(String diseaseString) {
        DiseaseAcronym acronym = FACTORY.buildDiseaseAcronym();
        Matcher parenthesisMatcher = BETWEEN_PARENTHESIS_PATTERN.matcher(diseaseString);
        if (parenthesisMatcher.find()) {
            String acronymString = parenthesisMatcher.group(1);
            acronym.setValue(acronymString);
        }
        return acronym;
    }

    private DiseaseDescription populateDiseaseDescription(String diseaseString) {
        DiseaseDescription description = FACTORY.buildDiseaseDescription();
        String descriptionString = diseaseString;
        ArrayList<EvidenceId> evidenceIds = new ArrayList<EvidenceId>();
        descriptionString = CommentTranslatorHelper.stripEvidenceIds(descriptionString, evidenceIds);
        description.setValue(descriptionString);
        description.setEvidenceIds(evidenceIds);
        return description;
    }

    private DiseaseReference populateDiseaseReference(String diseaseString) {
        DiseaseReference reference = FACTORY.buildDiseaseReference();
        Matcher bracketsMatcher = BETWEEN_SQUARE_BRACKETS_PATTERN.matcher(diseaseString);
        if (bracketsMatcher.find()) {
            String referenceString = bracketsMatcher.group(1);
            String[] referenceElements = referenceString.split(":");
            DiseaseReferenceId id = FACTORY.buildDiseaseReferenceId();
            id.setValue(referenceElements[1]);
            reference.setDiseaseReferenceId(id);
            DiseaseReferenceType referenceType = DiseaseReferenceType.typeOf(referenceElements[0]);
            reference.setDiseaseReferenceType(referenceType);
        }
        return reference;
    }
}

