/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.keywordlist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.factories.KeywordListFactory;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoId;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoMapping;
import uk.ac.ebi.kraken.interfaces.keywordlist.GoTerm;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordCategory;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordEntry;
import uk.ac.ebi.kraken.model.factories.DefaultKeywordListFactory;
import uk.ac.ebi.kraken.parser.keywordlist.CategoryParser;
import uk.ac.ebi.kraken.parser.keywordlist.KeywordLineType;

public class KeywordListParser {
    private BufferedReader reader;
    private static Map<String, KeywordCategory> categoryMap;
    private KeywordListFactory kwListFactory;

    public KeywordListParser(Reader reader) {
        this.reader = new BufferedReader(reader);
        this.kwListFactory = DefaultKeywordListFactory.getInstance();
    }

    public static Collection<KeywordEntry> parseAll(String reader) throws IOException {
        if (categoryMap == null) {
            categoryMap = CategoryParser.buildCategoryMap(new StringReader(reader));
        }
        KeywordListParser parser = new KeywordListParser(new StringReader(reader));
        return parser.parse();
    }

    public static Collection<KeywordEntry> parseAll(File file) throws IOException {
        if (categoryMap == null) {
            categoryMap = CategoryParser.buildCategoryMap(new FileReader(file));
        }
        KeywordListParser parser = new KeywordListParser(new FileReader(file));
        return parser.parse();
    }

    public static Collection<KeywordCategory> parseAllCategories(String reader) throws IOException {
        if (categoryMap == null) {
            categoryMap = CategoryParser.buildCategoryMap(new StringReader(reader));
        }
        return categoryMap.values();
    }

    public Collection<KeywordEntry> parse(Map<String, KeywordCategory> categoryMap) throws IOException {
        this.initializeStream();
        ArrayList<KeywordEntry> retVal = new ArrayList<KeywordEntry>();
        if (this.reader.ready()) {
            String line = null;
            StringBuilder deSB = null;
            KeywordEntry entry = null;
            line = this.reader.readLine();
            while (line != null) {
                String lineTypeString;
                if (line.length() > 4) {
                    lineTypeString = line.substring(0, 5);
                    if (line.endsWith(".")) {
                        line = line.substring(0, line.length() - 1);
                    }
                } else {
                    lineTypeString = line.length() > 1 ? line : line;
                }
                if (lineTypeString != null) {
                    switch (KeywordLineType.getType(lineTypeString.trim())) {
                        case AC: {
                            if (entry == null) break;
                            entry.setAccession(this.kwListFactory.buildAccession(line.substring(5)));
                            break;
                        }
                        case AN: {
                            if (entry == null) break;
                            entry.getAnnotations().add(this.kwListFactory.buildAnnotation(line.substring(5)));
                            break;
                        }
                        case CA: {
                            if (entry == null) break;
                            entry.setCategory(categoryMap.get(line.substring(5)));
                            break;
                        }
                        case DE: {
                            if (deSB == null) break;
                            if (deSB.length() > 0) {
                                deSB.append('\n');
                            }
                            deSB.append(line.substring(5));
                            break;
                        }
                        case GO: {
                            if (entry == null) break;
                            this.addGoMapping(entry, line.substring(5));
                            break;
                        }
                        case HI: {
                            if (entry == null) break;
                            entry.getHierachies().add(this.kwListFactory.buildHierachy(line.substring(5)));
                            break;
                        }
                        case IC: {
                            break;
                        }
                        case ID: {
                            entry = this.kwListFactory.buildEntry();
                            entry.setIdentifier(this.kwListFactory.buildIdentifier(line.substring(5)));
                            deSB = new StringBuilder();
                            break;
                        }
                        case RU: {
                            if (entry == null) break;
                            entry.getRules().add(this.kwListFactory.buildRule(line.substring(5)));
                            break;
                        }
                        case SY: {
                            if (entry == null) break;
                            this.addSynonyms(entry, line.substring(5));
                            break;
                        }
                        case TERM: {
                            if (entry == null) break;
                            entry.setDescription(this.kwListFactory.buildDescription(deSB.toString()));
                            retVal.add(entry);
                            entry = null;
                            break;
                        }
                        case UNKNOWN: {
                            break;
                        }
                    }
                }
                line = this.reader.readLine();
            }
        }
        this.closeStream();
        return retVal;
    }

    private Collection<KeywordEntry> parse() throws IOException {
        return this.parse(categoryMap);
    }

    private void addSynonyms(KeywordEntry keyword, String synonymLine) {
        StringTokenizer stringTokenizer = new StringTokenizer(synonymLine, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String synonym = stringTokenizer.nextToken().trim();
            if (synonym.endsWith(".")) {
                synonym = synonym.substring(0, synonym.length() - 1);
            }
            keyword.getSynonyms().add(this.kwListFactory.buildSynonym(synonym));
        }
    }

    private void addGoMapping(KeywordEntry keyword, String goLine) {
        GoMapping goMap = this.kwListFactory.buildGoMapping();
        StringTokenizer stringTokenizer = new StringTokenizer(goLine, ";");
        String tokenOne = stringTokenizer.nextToken();
        GoId goId = this.kwListFactory.buildGoId(tokenOne.trim());
        goMap.setGoId(goId);
        if (stringTokenizer.hasMoreTokens()) {
            String tokenTwo = stringTokenizer.nextToken();
            GoTerm goTerm = this.kwListFactory.buildGoTerm(tokenTwo.trim());
            goMap.setGoTerm(goTerm);
        }
        keyword.getGoMappings().add(goMap);
    }

    private void closeStream() throws IOException {
        this.reader.close();
    }

    private void initializeStream() throws IOException {
        if (this.reader.ready()) {
            String line = null;
            while ((line = this.reader.readLine()) != null && !line.startsWith("_____")) {
            }
        }
    }
}

