/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.util;

import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCategory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCode;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType;

public class EvidenceCodeGenerator {
    public EvidenceCode convertToEvidenceCode(EvidenceCategory evidenceCategory, EvidenceType evidenceType) {
        EvidenceCode evidenceCode = null;
        block0 : switch (evidenceCategory) {
            case AA: {
                switch (evidenceType) {
                    case PROTIMP: 
                    case PROTEOMES: {
                        evidenceCode = EvidenceCode.ECO_0000313;
                        break block0;
                    }
                }
                evidenceCode = EvidenceCode.ECO_0000256;
                break;
            }
            case CURATION: {
                switch (evidenceType) {
                    case CURATOR: 
                    case COMMON_KNOWLEDGE: {
                        evidenceCode = EvidenceCode.ECO_0000305;
                        break;
                    }
                    case EXPERIMENTAL: 
                    case LITERATURE: {
                        evidenceCode = EvidenceCode.ECO_0000269;
                        break;
                    }
                    case IMPORT: {
                        evidenceCode = EvidenceCode.ECO_0000312;
                        break;
                    }
                    case OPINION: {
                        evidenceCode = EvidenceCode.ECO_0000303;
                        break;
                    }
                    case SIMILARITY: {
                        evidenceCode = EvidenceCode.ECO_0000250;
                        break;
                    }
                    case HAMAP_RULE: 
                    case PROSITE_PRORULE: {
                        evidenceCode = EvidenceCode.ECO_0000255;
                    }
                }
                break;
            }
            case IMPORT: {
                switch (evidenceType) {
                    default: 
                }
                evidenceCode = EvidenceCode.ECO_0000313;
            }
            case PROGRAMME: {
                switch (evidenceType) {
                    case HAMAP_RULE: {
                        evidenceCode = EvidenceCode.ECO_0000256;
                        break block0;
                    }
                }
                evidenceCode = EvidenceCode.ECO_0000257;
                break;
            }
            default: {
                evidenceCode = EvidenceCode.NOT_SPECIFIED;
            }
        }
        if (evidenceType == EvidenceType.SEQUENCE_ANALAYSIS) {
            evidenceCode = EvidenceCode.ECO_0000257;
        }
        if (evidenceType == EvidenceType.Proteomics) {
            evidenceCode = EvidenceCode.ECO_0000213;
        }
        return evidenceCode;
    }

    public EvidenceType convertToEvidenceType(EvidenceCode evidenceCode) {
        EvidenceType type = EvidenceType.NOT_SPECIFIED;
        switch (evidenceCode) {
            case ECO_0000305: {
                type = EvidenceType.CURATOR;
                break;
            }
            case ECO_0000303: {
                type = EvidenceType.OPINION;
                break;
            }
            case ECO_0000269: {
                type = EvidenceType.EXPERIMENTAL;
                break;
            }
            case ECO_0000312: {
                type = EvidenceType.IMPORT;
                break;
            }
            case ECO_0000250: {
                type = EvidenceType.SIMILARITY;
                break;
            }
            case ECO_0000255: {
                type = EvidenceType.HAMAP_RULE;
                break;
            }
            case ECO_0000213: {
                type = EvidenceType.Proteomics;
                break;
            }
            case ECO_0000257: {
                type = EvidenceType.SEQUENCE_ANALAYSIS;
                break;
            }
            default: {
                type = EvidenceType.NOT_SPECIFIED;
            }
        }
        return type;
    }

    public EvidenceCategory convertToEvidenceCategory(EvidenceCode evidenceCode) {
        EvidenceCategory evidenceCategory;
        switch (evidenceCode) {
            case ECO_0000305: 
            case ECO_0000303: 
            case ECO_0000269: 
            case ECO_0000312: 
            case ECO_0000250: 
            case ECO_0000255: 
            case ECO_0000001: 
            case ECO_0000006: 
            case ECO_0000034: 
            case ECO_0000044: 
            case ECO_0000244: {
                evidenceCategory = EvidenceCategory.CURATION;
                break;
            }
            case ECO_0000203: 
            case ECO_0000256: {
                evidenceCategory = EvidenceCategory.AA;
                break;
            }
            case ECO_0000213: 
            case ECO_0000313: {
                evidenceCategory = EvidenceCategory.IMPORT;
                break;
            }
            case ECO_0000257: 
            case ECO_0000028: {
                evidenceCategory = EvidenceCategory.PROGRAMME;
                break;
            }
            default: {
                evidenceCategory = EvidenceCategory.NOT_SPECIFIED;
            }
        }
        return evidenceCategory;
    }
}

