/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocationModifier;

public class FeatureLocationImpl
implements FeatureLocation {
    private static final long serialVersionUID = 1L;
    private FeatureLocationModifier startModifier;
    private FeatureLocationModifier endModifier;
    private int start;
    private int end;
    private String sequence;

    public FeatureLocationImpl() {
        this.start = -1;
        this.end = -1;
        this.startModifier = FeatureLocationModifier.UNKOWN;
        this.endModifier = FeatureLocationModifier.UNKOWN;
        this.sequence = "";
    }

    public FeatureLocationImpl(FeatureLocation copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.start = copy.getStart();
        this.startModifier = copy.getStartModifier();
        this.end = copy.getEnd();
        this.endModifier = copy.getEndModifier();
        this.sequence = copy.getSequence();
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public FeatureLocationModifier getStartModifier() {
        return this.startModifier;
    }

    @Override
    public FeatureLocationModifier getEndModifier() {
        return this.endModifier;
    }

    @Override
    public void setStartModifier(FeatureLocationModifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException();
        }
        this.startModifier = modifier;
    }

    @Override
    public void setEndModifier(FeatureLocationModifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException();
        }
        this.endModifier = modifier;
    }

    @Override
    public boolean isStartAvailable() {
        return this.start != -1;
    }

    @Override
    public boolean isEndAvailable() {
        return this.end != -1;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    public String toString() {
        return "[startModifier=" + (Object)((Object)this.startModifier) + ", endModifier=" + (Object)((Object)this.endModifier) + ", start=" + this.start + ", end=" + this.end + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + (this.endModifier == null ? 0 : this.endModifier.hashCode());
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        result = 31 * result + this.start;
        result = 31 * result + (this.startModifier == null ? 0 : this.startModifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureLocationImpl other = (FeatureLocationImpl)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.endModifier != other.endModifier) {
            return false;
        }
        if (this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence)) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.startModifier == other.startModifier;
    }
}

