/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.features;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class ConflictFeatureImpl
extends FeatureImpl
implements ConflictFeature {
    private List<ConflictReport> conflictReports;
    private FeatureDescription featureDescription;
    private FeatureSequence originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence();
    private List<FeatureSequence> alternativeSequences;

    public ConflictFeatureImpl() {
        this.alternativeSequences = new ArrayList<FeatureSequence>();
        this.conflictReports = new ArrayList<ConflictReport>();
        this.featureDescription = DefaultFeatureFactory.getInstance().buildFeatureDescription("");
    }

    public ConflictFeatureImpl(ConflictFeature feature) {
        super(feature);
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        this.conflictReports = new NoNullElementsList<ConflictReport>(new ArrayList());
        this.featureDescription = DefaultFeatureFactory.getInstance().buildFeatureDescription("");
        this.conflictReports = new NoNullElementsList<ConflictReport>(new ArrayList());
        for (ConflictReport conflictReport : feature.getConflictReports()) {
            this.conflictReports.add(DefaultFeatureFactory.getInstance().buildConflictReport(conflictReport));
        }
        if (feature.getFeatureDescription() != null) {
            this.featureDescription = DefaultFeatureFactory.getInstance().buildFeatureDescription(feature.getFeatureDescription());
        }
        this.originalSequence = DefaultFeatureFactory.getInstance().buildFeatureSequence(feature.getOriginalSequence());
        this.alternativeSequences = new NoNullElementsList<FeatureSequence>(new ArrayList());
        for (FeatureSequence featureSequence : feature.getAlternativeSequences()) {
            this.alternativeSequences.add(DefaultFeatureFactory.getInstance().buildFeatureSequence(featureSequence));
        }
    }

    @Override
    public FeatureType getType() {
        return FeatureType.CONFLICT;
    }

    @Override
    public FeatureDescription getFeatureDescription() {
        return this.featureDescription;
    }

    @Override
    public void setFeatureDescription(FeatureDescription description) {
        this.featureDescription = description;
    }

    @Override
    public List<ConflictReport> getConflictReports() {
        return this.conflictReports;
    }

    @Override
    public void setConflictReports(List<ConflictReport> conflictReports) {
        if (conflictReports == null) {
            throw new IllegalArgumentException();
        }
        this.conflictReports = conflictReports;
    }

    @Override
    public FeatureSequence getOriginalSequence() {
        return this.originalSequence;
    }

    @Override
    public void setOriginalSequence(FeatureSequence original) {
        this.originalSequence = original;
    }

    @Override
    public List<FeatureSequence> getAlternativeSequences() {
        return this.alternativeSequences;
    }

    @Override
    public void setAlternativeSequences(List<FeatureSequence> alternative) {
        this.alternativeSequences = alternative;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConflictFeatureImpl that = (ConflictFeatureImpl)o;
        if (this.alternativeSequences != null ? !this.alternativeSequences.equals(that.alternativeSequences) : that.alternativeSequences != null) {
            return false;
        }
        if (this.conflictReports != null ? !this.conflictReports.equals(that.conflictReports) : that.conflictReports != null) {
            return false;
        }
        if (this.featureDescription != null ? !this.featureDescription.equals(that.featureDescription) : that.featureDescription != null) {
            return false;
        }
        return !(this.originalSequence != null ? !this.originalSequence.equals(that.originalSequence) : that.originalSequence != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.conflictReports != null ? this.conflictReports.hashCode() : 0);
        result = 29 * result + (this.featureDescription != null ? this.featureDescription.hashCode() : 0);
        result = 29 * result + (this.originalSequence != null ? this.originalSequence.hashCode() : 0);
        result = 29 * result + (this.alternativeSequences != null ? this.alternativeSequences.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConflictFeatureImpl{conflictReports=" + this.conflictReports + ", featureDescription=" + this.featureDescription + ", originalSequence=" + this.originalSequence + ", alternativeSequences=" + this.alternativeSequences + '}';
    }
}

