/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.description;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class FieldImpl
implements Field {
    private FieldType type;
    private String value;
    private List<EvidenceId> evidenceIds;

    public FieldImpl() {
        this.type = FieldType.UNKNOWN;
        this.value = "";
        this.evidenceIds = new ArrayList<EvidenceId>();
    }

    public FieldImpl(Field that) {
        this.type = that.getType();
        this.value = that.getValue();
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId evidenceId : that.getEvidenceIds()) {
            this.evidenceIds.add(DefaultUniProtFactory.getInstance().buildEvidenceId(evidenceId));
        }
    }

    @Override
    public FieldType getType() {
        return this.type;
    }

    @Override
    public void setType(FieldType type) {
        this.type = type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldImpl that = (FieldImpl)o;
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "FieldImpl{type=" + (Object)((Object)this.type) + ", value='" + this.value + '\'' + '}';
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidenceIds = evidences;
    }
}

