/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class ProteinDescriptionImpl
implements ProteinDescription {
    private List<Section> includes;
    private List<Section> contains;
    private List<Flag> flags;
    private List<EvidenceId> evidenceIds;
    private Section section = DefaultUniProtFactory.getInstance().buildSection();

    public ProteinDescriptionImpl() {
        this.includes = new ArrayList<Section>();
        this.contains = new ArrayList<Section>();
        this.flags = new ArrayList<Flag>();
        this.evidenceIds = new ArrayList<EvidenceId>();
    }

    public ProteinDescriptionImpl(ProteinDescription that) {
        this();
        this.section = DefaultUniProtFactory.getInstance().buildSection(that.getSection());
        for (Section section : that.getContains()) {
            this.contains.add(DefaultUniProtFactory.getInstance().buildSection(section));
        }
        for (Section section : that.getIncludes()) {
            this.includes.add(DefaultUniProtFactory.getInstance().buildSection(section));
        }
        for (Flag type : that.getFlags()) {
            this.flags.add(type);
        }
        for (EvidenceId evidenceId : that.getEvidenceIds()) {
            this.evidenceIds.add(DefaultUniProtFactory.getInstance().buildEvidenceId(evidenceId));
        }
    }

    @Override
    public void setSection(Section section) {
        this.section = section;
    }

    @Override
    public Section getSection() {
        return this.section;
    }

    @Override
    public List<String> getEcNumbers() {
        ArrayList<String> ecNumbers = new ArrayList<String>();
        ecNumbers.addAll(this.findEcNumbers(this.section));
        for (Section include : this.includes) {
            ecNumbers.addAll(this.findEcNumbers(include));
        }
        for (Section contain : this.contains) {
            ecNumbers.addAll(this.findEcNumbers(contain));
        }
        return ecNumbers;
    }

    private List<String> findEcNumbers(Section section) {
        ArrayList<String> ecNumbers = new ArrayList<String>();
        for (Name name : section.getNames()) {
            List<Field> ecsInName = name.getFieldsByType(FieldType.EC);
            for (Field field : ecsInName) {
                ecNumbers.add(field.getValue());
            }
        }
        return ecNumbers;
    }

    @Override
    public Name getRecommendedName() {
        Name name = DefaultUniProtFactory.getInstance().buildName();
        List<Name> recNames = this.section.getNamesByType(NameType.RECNAME);
        if (recNames.size() == 1) {
            return recNames.get(0);
        }
        return name;
    }

    @Override
    public boolean hasRecommendedName() {
        List<Name> recNames = this.section.getNamesByType(NameType.RECNAME);
        return recNames.size() == 1;
    }

    @Override
    public void setRecommendedName(Name recommendedName) {
        List<Name> nameList = this.section.getNames();
        if (this.hasRecommendedName()) {
            Name name = this.getRecommendedName();
            nameList.remove(name);
        }
        nameList.add(recommendedName);
        this.section.setNames(nameList);
    }

    @Override
    public List<Name> getAlternativeNames() {
        return this.section.getNamesByType(NameType.ALTNAME);
    }

    @Override
    public boolean hasAlternativeNames() {
        List<Name> altNameList = this.section.getNamesByType(NameType.ALTNAME);
        return !altNameList.isEmpty();
    }

    @Override
    public void setAlternativeNames(List<Name> alternativeNames) {
        List<Name> nameList = this.section.getNames();
        if (this.hasAlternativeNames()) {
            List<Name> altNames = this.getAlternativeNames();
            nameList.removeAll(altNames);
        }
        nameList.addAll(alternativeNames);
        this.section.setNames(nameList);
    }

    @Override
    public List<Name> getSubNames() {
        return this.section.getNamesByType(NameType.SUBNAME);
    }

    @Override
    public boolean hasSubNames() {
        List<Name> altNameList = this.section.getNamesByType(NameType.SUBNAME);
        return !altNameList.isEmpty();
    }

    @Override
    public void setSubNames(List<Name> subNames) {
        List<Name> nameList = this.section.getNames();
        if (this.hasSubNames()) {
            List<Name> oldSubNames = this.getAlternativeNames();
            nameList.removeAll(oldSubNames);
        }
        nameList.addAll(subNames);
        this.section.setNames(nameList);
    }

    @Override
    public List<Section> getIncludes() {
        return this.includes;
    }

    @Override
    public void setIncludes(List<Section> includes) {
        this.includes = includes;
    }

    @Override
    public List<Section> getContains() {
        return this.contains;
    }

    @Override
    public void setContains(List<Section> contains) {
        this.contains = contains;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    @Override
    public List<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(List<Flag> flags) {
        this.flags = flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProteinDescriptionImpl that = (ProteinDescriptionImpl)o;
        if (!this.contains.equals(that.contains)) {
            return false;
        }
        if (!this.evidenceIds.equals(that.evidenceIds)) {
            return false;
        }
        if (!this.includes.equals(that.includes)) {
            return false;
        }
        if (!this.section.equals(that.section)) {
            return false;
        }
        return this.flags.equals(that.flags);
    }

    public int hashCode() {
        int result = this.includes.hashCode();
        result = 31 * result + this.contains.hashCode();
        result = 31 * result + this.evidenceIds.hashCode();
        result = 31 * result + this.section.hashCode();
        result = 31 * result + this.flags.hashCode();
        return result;
    }

    public Collection<EvidenceId> collectEvidences() {
        HashSet<EvidenceId> evidences = new HashSet<EvidenceId>();
        evidences.addAll(this.evidenceIds);
        evidences.addAll(this.section.getEvidenceIds());
        this.section.getNames().forEach(val -> {
            evidences.addAll(val.getEvidenceIds());
            val.getFields().forEach(fl -> evidences.addAll(fl.getEvidenceIds()));
        });
        this.flags.forEach(fl -> evidences.addAll(fl.getEvidenceIds()));
        this.includes.forEach(include -> include.getNames().forEach(val -> {
            evidences.addAll(val.getEvidenceIds());
            val.getFields().forEach(fl -> evidences.addAll(fl.getEvidenceIds()));
        }));
        this.contains.forEach(contain -> contain.getNames().forEach(val -> {
            evidences.addAll(val.getEvidenceIds());
            val.getFields().forEach(fl -> evidences.addAll(fl.getEvidenceIds()));
        }));
        return evidences;
    }
}

