/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.msd;

import uk.ac.ebi.kraken.interfaces.common.NewtTaxon;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.msd.Chain;
import uk.ac.ebi.kraken.interfaces.msd.ChainId;
import uk.ac.ebi.kraken.interfaces.msd.MolType;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.factories.DefaultMsdFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class ChainImpl
implements Chain,
PersistentObject {
    private NewtTaxon taxon;
    private ChainId chainId;
    private UniProtAccession uniProtAccession;
    private UniProtId uniProtId;
    private int theStart;
    private int startObs;
    private int theEnd;
    private int endObs;
    private Sequence sequence;
    private MolType molType;
    private long id;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public ChainImpl() {
        DefaultMsdFactory msdFactory = DefaultMsdFactory.getInstance();
        DefaultUniProtFactory uniprotFactory = DefaultUniProtFactory.getInstance();
        this.taxon = msdFactory.buildNewtTaxon("");
        this.chainId = msdFactory.buildChainId("");
        this.uniProtAccession = uniprotFactory.buildPrimaryUniProtAccession("");
        this.uniProtId = uniprotFactory.buildUniProtId("");
        this.sequence = uniprotFactory.buildSequence();
        this.molType = MolType.PROTEIN;
    }

    @Override
    public NewtTaxon getTaxon() {
        return this.taxon;
    }

    @Override
    public void setTaxon(NewtTaxon taxon) {
        if (taxon == null) {
            throw new IllegalArgumentException();
        }
        this.taxon = taxon;
    }

    @Override
    public ChainId getChainId() {
        return this.chainId;
    }

    @Override
    public void setChainId(ChainId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.chainId = id;
    }

    @Override
    public UniProtAccession getUniProtAccession() {
        return this.uniProtAccession;
    }

    @Override
    public void setUniProtAccession(UniProtAccession uniProtAccession) {
        if (uniProtAccession == null) {
            throw new IllegalArgumentException();
        }
        this.uniProtAccession = uniProtAccession;
    }

    @Override
    public UniProtId getUniProtId() {
        return this.uniProtId;
    }

    @Override
    public void setUniProtId(UniProtId uniProtId) {
        if (uniProtId == null) {
            throw new IllegalArgumentException();
        }
        this.uniProtId = uniProtId;
    }

    @Override
    public int getTheStart() {
        return this.theStart;
    }

    @Override
    public void setTheStart(int start) {
        this.theStart = start;
    }

    @Override
    public int getStartObs() {
        return this.startObs;
    }

    @Override
    public void setStartObs(int startObs) {
        this.startObs = startObs;
    }

    @Override
    public int getTheEnd() {
        return this.theEnd;
    }

    @Override
    public void setTheEnd(int theEnd) {
        this.theEnd = theEnd;
    }

    @Override
    public int getEndObs() {
        return this.endObs;
    }

    @Override
    public void setEndObs(int endObs) {
        this.endObs = endObs;
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(Sequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = sequence;
    }

    public Sequence getObservedSequence() {
        return new SequenceImpl();
    }

    @Override
    public MolType getMolType() {
        return this.molType;
    }

    @Override
    public void setMolType(MolType molType) {
        if (molType == null) {
            throw new IllegalArgumentException();
        }
        this.molType = molType;
    }
}

