/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ActSiteFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.BindingFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CaBindFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ChainFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CoiledFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CompBiasFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CrosslinkFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.DisulfidFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.DnaBindFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.DomainFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocationModifier;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HelixFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.InitMetFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.IntramemFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.LinkedSugar;
import uk.ac.ebi.kraken.interfaces.uniprot.features.LipidFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MetalFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ModResFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MotifFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.NonConsFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.NonStandardAAFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.NonTerFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.NpBindFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.PeptideFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ProPepFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.RegionFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.RepeatFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.SignalFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.SiteFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.StrandFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.TopoDomFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.TransitFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.TransmemFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.TurnFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.UnsureFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarsplicIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ZnFingFeature;
import uk.ac.ebi.kraken.model.uniprot.features.ActSiteFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.BindingFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.CaBindFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.CarbohydFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.ChainFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.CoiledFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.CompBiasFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.ConflictFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.ConflictReportImpl;
import uk.ac.ebi.kraken.model.uniprot.features.CrosslinkFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.DisulfidFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.DnaBindFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.DomainFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureDescriptionImpl;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureIdImpl;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureLocationImpl;
import uk.ac.ebi.kraken.model.uniprot.features.FeatureSequenceImpl;
import uk.ac.ebi.kraken.model.uniprot.features.HelixFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.InitMetFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.IntramemFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.LinkedSugarImpl;
import uk.ac.ebi.kraken.model.uniprot.features.LipidFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.MetalFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.ModResFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.MotifFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.MutagenFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.MutagenReportImpl;
import uk.ac.ebi.kraken.model.uniprot.features.NonConsFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.NonStandardAAFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.NonTerFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.NpBindFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.PeptideFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.ProPepFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.RegionFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.RepeatFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.SignalFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.SiteFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.StrandFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.TopoDomFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.TransitFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.TransmemFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.TurnFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.UnsureFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.VarSeqFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.VarSplicIsoFormImpl;
import uk.ac.ebi.kraken.model.uniprot.features.VariantFeatureImpl;
import uk.ac.ebi.kraken.model.uniprot.features.VariantReportImpl;
import uk.ac.ebi.kraken.model.uniprot.features.ZnFingFeatureImpl;

public class DefaultFeatureFactory
implements FeatureFactory {
    private static DefaultFeatureFactory singletonInstance;

    protected DefaultFeatureFactory() {
    }

    public static DefaultFeatureFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultFeatureFactory();
        }
        return singletonInstance;
    }

    @Override
    public <T extends Feature> T buildFeature(FeatureType featureType) {
        FeatureImpl result = null;
        switch (featureType) {
            case ACT_SITE: {
                result = new ActSiteFeatureImpl();
                break;
            }
            case BINDING: {
                result = new BindingFeatureImpl();
                break;
            }
            case CA_BIND: {
                result = new CaBindFeatureImpl();
                break;
            }
            case CONFLICT: {
                result = new ConflictFeatureImpl();
                break;
            }
            case CARBOHYD: {
                result = new CarbohydFeatureImpl();
                break;
            }
            case CHAIN: {
                result = new ChainFeatureImpl();
                break;
            }
            case COILED: {
                result = new CoiledFeatureImpl();
                break;
            }
            case COMPBIAS: {
                result = new CompBiasFeatureImpl();
                break;
            }
            case CROSSLNK: {
                result = new CrosslinkFeatureImpl();
                break;
            }
            case DISULFID: {
                result = new DisulfidFeatureImpl();
                break;
            }
            case DNA_BIND: {
                result = new DnaBindFeatureImpl();
                break;
            }
            case DOMAIN: {
                result = new DomainFeatureImpl();
                break;
            }
            case HELIX: {
                result = new HelixFeatureImpl();
                break;
            }
            case INIT_MET: {
                result = new InitMetFeatureImpl();
                break;
            }
            case INTRAMEM: {
                result = new IntramemFeatureImpl();
                break;
            }
            case LIPID: {
                result = new LipidFeatureImpl();
                break;
            }
            case METAL: {
                result = new MetalFeatureImpl();
                break;
            }
            case MOD_RES: {
                result = new ModResFeatureImpl();
                break;
            }
            case MOTIF: {
                result = new MotifFeatureImpl();
                break;
            }
            case MUTAGEN: {
                result = new MutagenFeatureImpl();
                break;
            }
            case NON_CONS: {
                result = new NonConsFeatureImpl();
                break;
            }
            case NON_TER: {
                result = new NonTerFeatureImpl();
                break;
            }
            case NP_BIND: {
                result = new NpBindFeatureImpl();
                break;
            }
            case PEPTIDE: {
                result = new PeptideFeatureImpl();
                break;
            }
            case PROPEP: {
                result = new ProPepFeatureImpl();
                break;
            }
            case REGION: {
                result = new RegionFeatureImpl();
                break;
            }
            case REPEAT: {
                result = new RepeatFeatureImpl();
                break;
            }
            case NON_STD: {
                result = new NonStandardAAFeatureImpl();
                break;
            }
            case SIGNAL: {
                result = new SignalFeatureImpl();
                break;
            }
            case SITE: {
                result = new SiteFeatureImpl();
                break;
            }
            case STRAND: {
                result = new StrandFeatureImpl();
                break;
            }
            case TOPO_DOM: {
                result = new TopoDomFeatureImpl();
                break;
            }
            case TRANSIT: {
                result = new TransitFeatureImpl();
                break;
            }
            case TRANSMEM: {
                result = new TransmemFeatureImpl();
                break;
            }
            case TURN: {
                result = new TurnFeatureImpl();
                break;
            }
            case UNSURE: {
                result = new UnsureFeatureImpl();
                break;
            }
            case VARIANT: {
                result = new VariantFeatureImpl();
                break;
            }
            case VAR_SEQ: {
                result = new VarSeqFeatureImpl();
                break;
            }
            case ZN_FING: {
                result = new ZnFingFeatureImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("FeatureType : " + (Object)((Object)featureType) + " is not supported");
            }
        }
        return (T)result;
    }

    @Override
    public <T extends Feature> T buildFeature(Feature aFeature) {
        FeatureImpl result = null;
        switch (aFeature.getType()) {
            case ACT_SITE: {
                result = new ActSiteFeatureImpl((ActSiteFeature)aFeature);
                break;
            }
            case BINDING: {
                result = new BindingFeatureImpl((BindingFeature)aFeature);
                break;
            }
            case CA_BIND: {
                result = new CaBindFeatureImpl((CaBindFeature)aFeature);
                break;
            }
            case CARBOHYD: {
                result = new CarbohydFeatureImpl((CarbohydFeature)aFeature);
                break;
            }
            case CHAIN: {
                result = new ChainFeatureImpl((ChainFeature)aFeature);
                break;
            }
            case COILED: {
                result = new CoiledFeatureImpl((CoiledFeature)aFeature);
                break;
            }
            case COMPBIAS: {
                result = new CompBiasFeatureImpl((CompBiasFeature)aFeature);
                break;
            }
            case CROSSLNK: {
                result = new CrosslinkFeatureImpl((CrosslinkFeature)aFeature);
                break;
            }
            case CONFLICT: {
                result = new ConflictFeatureImpl((ConflictFeature)aFeature);
                break;
            }
            case DISULFID: {
                result = new DisulfidFeatureImpl((DisulfidFeature)aFeature);
                break;
            }
            case DNA_BIND: {
                result = new DnaBindFeatureImpl((DnaBindFeature)aFeature);
                break;
            }
            case DOMAIN: {
                result = new DomainFeatureImpl((DomainFeature)aFeature);
                break;
            }
            case HELIX: {
                result = new HelixFeatureImpl((HelixFeature)aFeature);
                break;
            }
            case INIT_MET: {
                result = new InitMetFeatureImpl((InitMetFeature)aFeature);
                break;
            }
            case INTRAMEM: {
                result = new IntramemFeatureImpl((IntramemFeature)aFeature);
                break;
            }
            case LIPID: {
                result = new LipidFeatureImpl((LipidFeature)aFeature);
                break;
            }
            case METAL: {
                result = new MetalFeatureImpl((MetalFeature)aFeature);
                break;
            }
            case MOD_RES: {
                result = new ModResFeatureImpl((ModResFeature)aFeature);
                break;
            }
            case MOTIF: {
                result = new MotifFeatureImpl((MotifFeature)aFeature);
                break;
            }
            case MUTAGEN: {
                result = new MutagenFeatureImpl((MutagenFeature)aFeature);
                break;
            }
            case NON_CONS: {
                result = new NonConsFeatureImpl((NonConsFeature)aFeature);
                break;
            }
            case NON_TER: {
                result = new NonTerFeatureImpl((NonTerFeature)aFeature);
                break;
            }
            case NP_BIND: {
                result = new NpBindFeatureImpl((NpBindFeature)aFeature);
                break;
            }
            case PEPTIDE: {
                result = new PeptideFeatureImpl((PeptideFeature)aFeature);
                break;
            }
            case PROPEP: {
                result = new ProPepFeatureImpl((ProPepFeature)aFeature);
                break;
            }
            case REGION: {
                result = new RegionFeatureImpl((RegionFeature)aFeature);
                break;
            }
            case REPEAT: {
                result = new RepeatFeatureImpl((RepeatFeature)aFeature);
                break;
            }
            case NON_STD: {
                result = new NonStandardAAFeatureImpl((NonStandardAAFeature)aFeature);
                break;
            }
            case SIGNAL: {
                result = new SignalFeatureImpl((SignalFeature)aFeature);
                break;
            }
            case SITE: {
                result = new SiteFeatureImpl((SiteFeature)aFeature);
                break;
            }
            case STRAND: {
                result = new StrandFeatureImpl((StrandFeature)aFeature);
                break;
            }
            case TOPO_DOM: {
                result = new TopoDomFeatureImpl((TopoDomFeature)aFeature);
                break;
            }
            case TRANSIT: {
                result = new TransitFeatureImpl((TransitFeature)aFeature);
                break;
            }
            case TRANSMEM: {
                result = new TransmemFeatureImpl((TransmemFeature)aFeature);
                break;
            }
            case TURN: {
                result = new TurnFeatureImpl((TurnFeature)aFeature);
                break;
            }
            case UNSURE: {
                result = new UnsureFeatureImpl((UnsureFeature)aFeature);
                break;
            }
            case VARIANT: {
                result = new VariantFeatureImpl((VariantFeature)aFeature);
                break;
            }
            case VAR_SEQ: {
                result = new VarSeqFeatureImpl((VarSeqFeature)aFeature);
                break;
            }
            case ZN_FING: {
                result = new ZnFingFeatureImpl((ZnFingFeature)aFeature);
                break;
            }
            default: {
                System.out.println((Object)aFeature.getType());
                throw new IllegalArgumentException();
            }
        }
        return (T)result;
    }

    @Override
    public <T extends Feature> T buildFeature(FeatureType featureType, FeatureStatus featureStatus) {
        T result = this.buildFeature(featureType);
        result.setFeatureStatus(featureStatus);
        return result;
    }

    @Override
    public FeatureLocation buildFeatureLocation() {
        return new FeatureLocationImpl();
    }

    @Override
    public FeatureLocation buildFeatureLocation(int start, int end) {
        return this.buildFeatureLocation(start, FeatureLocationModifier.EXACT, end, FeatureLocationModifier.EXACT);
    }

    @Override
    public FeatureLocation buildFeatureLocation(int start, FeatureLocationModifier startModifier, int end, FeatureLocationModifier endModifier) {
        FeatureLocationImpl result = new FeatureLocationImpl();
        result.setStart(start);
        result.setStartModifier(startModifier);
        result.setEnd(end);
        result.setEndModifier(endModifier);
        return result;
    }

    @Override
    public FeatureLocation buildFeatureLocation(FeatureLocation featureLocation) {
        return new FeatureLocationImpl(featureLocation);
    }

    @Override
    public FeatureLocation buildFeatureLocationWithUnknownStart(int end, FeatureLocationModifier endModifier) {
        FeatureLocationImpl result = new FeatureLocationImpl();
        result.setStartModifier(FeatureLocationModifier.UNKOWN);
        result.setEnd(end);
        result.setEndModifier(endModifier);
        return result;
    }

    @Override
    public FeatureLocation buildFeatureLocationWithUnknownEnd(int start, FeatureLocationModifier startModifier) {
        FeatureLocationImpl result = new FeatureLocationImpl();
        result.setEndModifier(FeatureLocationModifier.UNKOWN);
        result.setStart(start);
        result.setStartModifier(startModifier);
        return result;
    }

    @Override
    public FeatureLocation buildFeatureLocationWithUnknownLocation() {
        FeatureLocationImpl result = new FeatureLocationImpl();
        result.setEndModifier(FeatureLocationModifier.UNKOWN);
        result.setStartModifier(FeatureLocationModifier.UNKOWN);
        return result;
    }

    @Override
    public ConflictReport buildConflictReport() {
        return new ConflictReportImpl();
    }

    @Override
    public ConflictReport buildConflictReport(String value) {
        ConflictReportImpl result = new ConflictReportImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public ConflictReport buildConflictReport(ConflictReport copy) {
        return new ConflictReportImpl(copy);
    }

    @Override
    public FeatureDescription buildFeatureDescription(FeatureDescription copy) {
        return new FeatureDescriptionImpl(copy);
    }

    @Override
    public FeatureDescription buildFeatureDescription() {
        return this.buildFeatureDescription("");
    }

    @Override
    public FeatureDescription buildFeatureDescription(String value) {
        FeatureDescriptionImpl result = new FeatureDescriptionImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public FeatureSequence buildFeatureSequence() {
        return new FeatureSequenceImpl();
    }

    @Override
    public FeatureSequence buildFeatureSequence(String value) {
        FeatureSequence result = this.buildFeatureSequence();
        result.setValue(value);
        return result;
    }

    @Override
    public FeatureSequence buildFeatureSequence(FeatureSequence copy) {
        return new FeatureSequenceImpl(copy);
    }

    @Override
    public FeatureId buildFeatureId(String value) {
        FeatureIdImpl result = new FeatureIdImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public FeatureId buildFeatureId(FeatureId featureId) {
        return new FeatureIdImpl(featureId);
    }

    @Override
    public FeatureId buildFeatureId() {
        return this.buildFeatureId("");
    }

    @Override
    public VariantReport buildVariantReport() {
        return new VariantReportImpl();
    }

    @Override
    public VariantReport buildVariantReport(String value) {
        VariantReportImpl result = new VariantReportImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public VariantReport buildVariantReport(VariantReport copy) {
        return new VariantReportImpl(copy);
    }

    @Override
    public MutagenReport buildMutagenReport() {
        return new MutagenReportImpl();
    }

    @Override
    public MutagenReport buildMutagenReport(String value) {
        MutagenReport result = this.buildMutagenReport();
        result.setValue(value);
        return result;
    }

    @Override
    public MutagenReport buildMutagenReport(MutagenReport copy) {
        return new MutagenReportImpl(copy);
    }

    @Override
    public LinkedSugar buildLinkedSugar(String value) {
        LinkedSugarImpl result = new LinkedSugarImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public LinkedSugar buildLinkedSugar(LinkedSugar copy) {
        return new LinkedSugarImpl(copy);
    }

    @Override
    public LinkedSugar buildLinkedSugar() {
        return this.buildLinkedSugar("");
    }

    @Override
    public VarsplicIsoform buildVarsplicIsoform(String value) {
        VarSplicIsoFormImpl result = new VarSplicIsoFormImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public VarsplicIsoform buildVarsplicIsoform(VarsplicIsoform copy) {
        return new VarSplicIsoFormImpl(copy);
    }

    @Override
    public VarsplicIsoform buildVarsplicIsoform() {
        return this.buildVarsplicIsoform("");
    }
}

