/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.ft;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocationModifier;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasAlternativeSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;

public class FTLineBuilderHelper {
    private static final String OR_TWO_SPACES = " or ";
    private static final String OR_LEFT_SPACE = " or";
    private static final String OR_RIGHT_SPACE = "or ";
    private static final String ARROW_TWO_SPACES = " -> ";
    private static final String ARROW_LEFT_SPACE = " ->";
    private static final String ARROW_RIGHT_SPACE = "-> ";
    private static final String ARROW = "->";
    private static final String COMMA = ",";
    private static final String MISSING = "Missing";
    private static final String QUESTION_MARK = "?";
    private static final String SPACE = " ";
    public static final String FT_ID = "/id=\"";
    public static final String FT_LINE_PREFIX_2 = "FT                   ";
    public static final String SPACE_LOCATION_DESCRIPTION = "       ";
    public static final String FT_LINE_PREFIX = "FT   ";
    public static final int NUMBER_OF_SPACE = 19;
    public static final String COLON = ":";
    public static final String STOP = ".";
    public static final String DOUBLE_STOP = "..";
    public static final String NOTE_PREFIX = "/note=\"";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String EVIDENCE_PREFIX = "/evidence=\"";

    public static StringBuilder getDescriptionString(Feature feature) {
        StringBuilder sb = new StringBuilder();
        if (feature instanceof HasFeatureDescription) {
            sb.append(((HasFeatureDescription)feature).getFeatureDescription().getValue());
        }
        return sb;
    }

    public static List<String> buildNote(Feature feature, StringBuilder extra, boolean includeFFMarkup) {
        StringBuilder note = new StringBuilder(FTLineBuilderHelper.replaceDoubleQuoteWithDoubleDoubleQuote(extra.toString()));
        boolean hasAlternativeSequence = feature instanceof HasAlternativeSequence;
        if (note.length() == 0 && !hasAlternativeSequence) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(FT_LINE_PREFIX_2);
        }
        sb.append(NOTE_PREFIX).append(note.toString());
        String[] seps = new String[]{SPACE, "-"};
        if (!hasAlternativeSequence) {
            sb.append(DOUBLE_QUOTE);
            if (includeFFMarkup) {
                return FFLineWrapper.buildLines(sb.toString(), seps, FT_LINE_PREFIX_2, 80);
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(sb.toString());
            return result;
        }
        return FTLineBuilderHelper.addAlternativeSequence(sb, (HasAlternativeSequence)feature, includeFFMarkup);
    }

    public static List<String> buildNote(Feature feature, boolean includeFFMarkup) {
        StringBuilder note = FTLineBuilderHelper.buildExtra(feature);
        return FTLineBuilderHelper.buildNote(feature, note, includeFFMarkup);
    }

    public static StringBuilder buildEvidences(List<EvidenceId> evidences, boolean includeFFMarkup) {
        String evidence = EvidenceLine.export(evidences, false);
        if (evidence.length() == 0) {
            return new StringBuilder();
        }
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(FT_LINE_PREFIX_2);
        }
        sb.append(EVIDENCE_PREFIX).append(evidence).append(DOUBLE_QUOTE);
        return sb;
    }

    public static StringBuilder buildFeatureId(FeatureId ftId, boolean includeFFMarkup) {
        StringBuilder sb = new StringBuilder();
        if (ftId != null && !Strings.isNullOrEmpty((String)ftId.getValue())) {
            if (includeFFMarkup) {
                sb.append(FT_LINE_PREFIX_2);
            }
            sb.append(FT_ID);
            sb.append(ftId.getValue());
            sb.append(DOUBLE_QUOTE);
        }
        return sb;
    }

    public static StringBuilder buildExtra(Feature feature) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)FTLineBuilderHelper.getDescriptionString(feature));
        boolean hasDescription = sb.length() > 0;
        StringBuilder status = FTLineBuilderHelper.getStatus(feature.getFeatureStatus());
        if (status.length() > 0) {
            if (hasDescription) {
                sb.append(" (");
            }
            sb.append(feature.getFeatureStatus().getValue());
            if (hasDescription) {
                sb.append(")");
            }
        }
        return sb;
    }

    public static StringBuilder getStatus(FeatureStatus status) {
        StringBuilder sb = new StringBuilder();
        if (status == FeatureStatus.POTENTIAL || status == FeatureStatus.PROBABLE || status == FeatureStatus.BY_SIMILARITY) {
            sb.append(status.getValue());
        }
        return sb;
    }

    public static StringBuilder buildFeatureHeader(Feature feature, boolean includeFFMarkup) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(FT_LINE_PREFIX);
        }
        sb.append((Object)feature.getType());
        if (includeFFMarkup) {
            int length = feature.getType().name().length();
            int numberOfSpace = 16 - length;
            for (int i = 0; i < numberOfSpace; ++i) {
                sb.append(SPACE);
            }
        } else {
            sb.append(SPACE);
        }
        if (feature.getFeatureLocation() != null) {
            sb.append(FTLineBuilderHelper.buildFeatureLocation(feature.getFeatureLocation()));
        }
        return sb;
    }

    public static String buildFeatureLocation(FeatureLocation location) {
        StringBuilder temp = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)location.getSequence())) {
            temp.append(location.getSequence()).append(COLON);
        }
        String start = FTLineBuilderHelper.getModifierString(location.getStartModifier(), false);
        if (location.getStart() > -1 && location.getStartModifier() != FeatureLocationModifier.UNKOWN) {
            start = start + location.getStart();
        }
        String end = FTLineBuilderHelper.getModifierString(location.getEndModifier(), true);
        if (location.getEnd() > -1 && location.getEndModifier() != FeatureLocationModifier.UNKOWN) {
            end = end + location.getEnd();
        }
        temp.append(start);
        if (!start.equals(end)) {
            temp.append(DOUBLE_STOP).append(end);
        }
        return temp.toString();
    }

    private static String getModifierString(FeatureLocationModifier mod, boolean isEnd) {
        String value = "";
        switch (mod) {
            case EXACT: {
                break;
            }
            case UNKOWN: {
                value = QUESTION_MARK;
                break;
            }
            case UNSURE: {
                value = QUESTION_MARK;
                break;
            }
            case OUTSIDE_KNOWN_SEQUENCE: {
                value = isEnd ? ">" : "<";
            }
        }
        return value;
    }

    public static List<String> addAlternativeSequence(StringBuilder sb, HasAlternativeSequence featureWithAlternativeSequence, boolean includeFFMarkings) {
        if (includeFFMarkings) {
            return FTLineBuilderHelper.addAlternativeSequence(sb, featureWithAlternativeSequence);
        }
        return FTLineBuilderHelper.addAlternativeSequenceNoFFMarking(sb, featureWithAlternativeSequence);
    }

    private static List<String> addAlternativeSequenceNoFFMarking(StringBuilder sb, HasAlternativeSequence featureWithAlternativeSequence) {
        ArrayList<String> lines = new ArrayList<String>();
        if (FTLineBuilderHelper.hasAlternativeSequence(featureWithAlternativeSequence)) {
            String originalSequence = featureWithAlternativeSequence.getOriginalSequence().getValue();
            sb.append(originalSequence);
            if (featureWithAlternativeSequence instanceof MutagenFeature) {
                sb.append(ARROW);
            } else {
                sb.append(ARROW_TWO_SPACES);
            }
            String joiner = FTLineBuilderHelper.getJoiner(featureWithAlternativeSequence);
            sb.append(featureWithAlternativeSequence.getAlternativeSequences().stream().map(Value::getValue).collect(Collectors.joining(joiner)));
        } else {
            sb.append(MISSING);
        }
        lines.add(sb.toString());
        return lines;
    }

    private static String getJoiner(HasAlternativeSequence featureWithAlternativeSequence) {
        if (featureWithAlternativeSequence instanceof ConflictFeature) {
            return OR_TWO_SPACES;
        }
        return COMMA;
    }

    private static boolean hasAlternativeSequence(HasAlternativeSequence featureWithAlternativeSequence) {
        return featureWithAlternativeSequence.getOriginalSequence() != null && !featureWithAlternativeSequence.getOriginalSequence().getValue().equals("") && !featureWithAlternativeSequence.getAlternativeSequences().isEmpty();
    }

    private static List<String> addAlternativeSequence(StringBuilder sb, HasAlternativeSequence featureWithAlternativeSequence) {
        ArrayList<String> lines = new ArrayList<String>();
        sb = FTLineBuilderHelper.wrapAdd(lines, sb, SPACE, FT_LINE_PREFIX_2, 80);
        if (FTLineBuilderHelper.hasAlternativeSequence(featureWithAlternativeSequence)) {
            sb = FTLineBuilderHelper.addOriginalSequence(sb, featureWithAlternativeSequence, lines);
            boolean first = true;
            for (FeatureSequence atlternativeSequence : featureWithAlternativeSequence.getAlternativeSequences()) {
                if (!first) {
                    FTLineBuilderHelper.addJoinForAlternativeSequence(sb, featureWithAlternativeSequence, lines);
                }
                sb.append(atlternativeSequence.getValue());
                sb = FTLineBuilderHelper.wrapAdd(lines, sb, "", FT_LINE_PREFIX_2, 80);
                first = false;
            }
        } else {
            sb.append(MISSING);
        }
        if (sb.length() > 0) {
            lines.add(sb.toString());
        }
        return lines;
    }

    private static boolean isLongerLineLength(StringBuilder sb, String val) {
        return sb.length() + val.length() > 80;
    }

    private static boolean isEqualLineLength(StringBuilder sb, String val) {
        return sb.length() + val.length() == 80;
    }

    private static StringBuilder addOriginalSequence(StringBuilder sb, HasAlternativeSequence featureWithAlternativeSequence, List<String> lines) {
        String originalSequence = featureWithAlternativeSequence.getOriginalSequence().getValue();
        sb.append(originalSequence);
        sb = FTLineBuilderHelper.wrapAdd(lines, sb, "", FT_LINE_PREFIX_2, 80);
        if (featureWithAlternativeSequence instanceof MutagenFeature) {
            if (FTLineBuilderHelper.isLongerLineLength(sb, ARROW)) {
                sb = FTLineBuilderHelper.addToLines(sb, lines);
            }
            sb.append(ARROW);
        } else if (FTLineBuilderHelper.isLongerLineLength(sb, ARROW_RIGHT_SPACE)) {
            sb = FTLineBuilderHelper.addToLines(sb, lines);
            sb.append(ARROW_RIGHT_SPACE);
        } else if (FTLineBuilderHelper.isEqualLineLength(sb, ARROW_LEFT_SPACE)) {
            sb.append(ARROW_LEFT_SPACE);
            sb = FTLineBuilderHelper.addToLines(sb, lines);
        } else {
            sb.append(ARROW_TWO_SPACES);
        }
        return sb;
    }

    private static StringBuilder addToLines(StringBuilder sb, List<String> lines) {
        lines.add(sb.toString());
        sb = new StringBuilder(FT_LINE_PREFIX_2);
        return sb;
    }

    private static void addJoinForAlternativeSequence(StringBuilder sb, HasAlternativeSequence featureWithAlternativeSequence, List<String> lines) {
        if (featureWithAlternativeSequence instanceof ConflictFeature) {
            if (FTLineBuilderHelper.isLongerLineLength(sb, OR_RIGHT_SPACE)) {
                sb = FTLineBuilderHelper.addToLines(sb, lines);
                sb = new StringBuilder(OR_RIGHT_SPACE);
            } else if (FTLineBuilderHelper.isEqualLineLength(sb, OR_LEFT_SPACE)) {
                sb.append(OR_LEFT_SPACE);
                sb = FTLineBuilderHelper.addToLines(sb, lines);
            } else {
                sb.append(OR_TWO_SPACES);
            }
        } else if (FTLineBuilderHelper.isLongerLineLength(sb, COMMA)) {
            lines.add(sb.toString());
            sb = new StringBuilder("FT                   ,");
        } else {
            sb.append(COMMA);
        }
    }

    private static StringBuilder wrapAdd(List<String> lines, StringBuilder sb, String sep, String prefix, int lineLength) {
        if (sb.length() <= lineLength) {
            return sb;
        }
        List<String> lines2 = FFLineWrapper.buildLines(sb.toString(), sep, prefix, lineLength);
        for (int i = 0; i < lines2.size(); ++i) {
            if (i == lines2.size() - 1) {
                sb = new StringBuilder(lines2.get(i));
                continue;
            }
            lines.add(lines2.get(i));
        }
        return sb;
    }

    public static String replaceDoubleQuoteWithDoubleDoubleQuote(String s) {
        return s.replaceAll(DOUBLE_QUOTE, "\"\"");
    }
}

