/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseCommentStructured;

public class DiseaseCCLineBuilder
extends CCLineBuilderAbstr<DiseaseCommentStructured> {
    @Override
    protected List<String> buildCommentLines(DiseaseCommentStructured comment, boolean includeFFMarkings, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkings) {
            this.addFlatFileMarkingsIfRequired(includeFFMarkings, sb);
        }
        this.addCommentTypeName(comment, sb);
        this.addMolecule(comment, sb, true);
        boolean needSpace = false;
        if (comment.hasDefinedDisease()) {
            sb.append(this.createDiseaseString(comment.getDisease()));
            sb = this.addEvidence(comment.getDisease().getDescription(), sb, showEvidence, ".");
            needSpace = true;
        }
        if (!comment.getNote().getTexts().isEmpty()) {
            if (needSpace) {
                sb.append(" ");
            }
            sb.append("Note=");
            boolean isfirst = true;
            for (EvidencedValue val : comment.getNote().getTexts()) {
                if (!isfirst) {
                    sb.append(" ");
                }
                sb.append(val.getValue());
                this.appendIfNot(sb, ".");
                sb = this.addEvidence(val, sb, showEvidence, ".");
                isfirst = false;
            }
        }
        if (includeFFMarkings) {
            return FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(sb.toString());
        return lines;
    }

    private String createDiseaseString(Disease disease) {
        String diseaseString = "";
        diseaseString = diseaseString + disease.getDiseaseId().getValue() + " (" + disease.getAcronym().getValue() + ") [" + disease.getReference().getDiseaseReferenceType().toDisplayName() + ":" + disease.getReference().getDiseaseReferenceId().getValue() + "]: " + disease.getDescription().getValue();
        return diseaseString;
    }
}

