/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.EnumMap;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.AlternativeProductsCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.BioPhyChemCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CatalyticActivityCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CofactorStructuredCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.DiseaseCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.InteractionCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.MassSpecCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.RNAEditingCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.SequenceCautionCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.SubCellCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.TextOnlyCCLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.WebResourceCCLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;

public class CommentLineBuilderFactory {
    private static final FFLineBuilder<TextOnlyComment> DEFAULT_BUILDER = new TextOnlyCCLineBuilder();
    private static final EnumMap<CommentType, FFLineBuilder<? extends Comment>> COMMENTS_BUILDER = new EnumMap(CommentType.class);

    public static <T extends Comment> FFLineBuilder<T> create(T f) {
        FFLineBuilder<? extends Comment> builder = COMMENTS_BUILDER.get((Object)f.getCommentType());
        if (builder != null) {
            return builder;
        }
        return DEFAULT_BUILDER;
    }

    static {
        COMMENTS_BUILDER.put(CommentType.ALTERNATIVE_PRODUCTS, new AlternativeProductsCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES, new BioPhyChemCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.DISEASE, new DiseaseCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.INTERACTION, new InteractionCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.MASS_SPECTROMETRY, new MassSpecCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.RNA_EDITING, new RNAEditingCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.SEQUENCE_CAUTION, new SequenceCautionCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.SUBCELLULAR_LOCATION, new SubCellCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.WEBRESOURCE, new WebResourceCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.COFACTOR, new CofactorStructuredCCLineBuilder());
        COMMENTS_BUILDER.put(CommentType.CATALYTIC_ACTIVITY, new CatalyticActivityCCLineBuilder());
    }
}

