/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.EvidenceLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReference;

public class CofactorStructuredCCLineBuilder
extends CCLineBuilderAbstr<CofactorCommentStructured> {
    private static final String EVIDENCE = "Evidence=";
    private static final String XREF = "Xref=";

    @Override
    protected List<String> buildCommentLines(CofactorCommentStructured comment, boolean includeFFMarkings, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder firstLine = new StringBuilder();
        firstLine.append(this.buildStartWithMolecule(comment, includeFFMarkings));
        String[] sep = new String[]{" "};
        if (firstLine.length() > 0) {
            lines.add(firstLine.toString());
        }
        for (Cofactor cofactor : comment.getCofactors()) {
            StringBuilder sb = new StringBuilder();
            if (includeFFMarkings) {
                sb.append(this.linePrefix);
            }
            sb.append("Name=").append(cofactor.getName()).append("; ");
            CofactorReference coRef = cofactor.getCofactorReference();
            sb.append(XREF).append(coRef.getCofactorReferenceType().toDisplayName()).append(":").append(coRef.getReferenceId()).append(";");
            if (!cofactor.getEvidenceIds().isEmpty()) {
                sb.append(" ");
                sb.append(EVIDENCE);
                String evStr = EvidenceLine.export(cofactor.getEvidenceIds()).trim();
                sb.append(evStr).append(";");
            }
            if (includeFFMarkings) {
                List<String> lls = FFLineWrapper.buildLines(sb.toString(), sep, "CC         ", 80);
                lines.addAll(lls);
                continue;
            }
            lines.add(sb.toString());
        }
        sep = new String[]{" ", "-"};
        if (comment.getNote() != null && !comment.getNote().getTexts().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            if (includeFFMarkings) {
                sb.append(this.linePrefix);
            }
            sb.append("Note=");
            String freeTextStr = this.buildFreeText(comment.getNote(), showEvidence, ".", ";");
            sb.append(freeTextStr);
            if (includeFFMarkings) {
                lines.addAll(FFLineWrapper.buildLines(sb.toString(), sep, this.linePrefix, 80));
            } else {
                lines.add(sb.toString());
            }
        }
        return lines;
    }
}

