/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.SourceLine;

public class SSSourceLineBuilder
extends FFLineBuilderAbstr<List<SourceLine>> {
    private static final String SOURCE_SECTION = "**   #################     SOURCE SECTION     ##################";
    private static final String PREFIX = "**   ";

    public SSSourceLineBuilder() {
        super(LineType.STAR_STAR);
    }

    @Override
    public String buildString(List<SourceLine> f) {
        return this.buildLine(f, false).toString();
    }

    @Override
    public String buildStringWithEvidence(List<SourceLine> f) {
        return this.buildLine(f, true).toString();
    }

    @Override
    protected FFLine buildLine(List<SourceLine> sourceLines, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!sourceLines.isEmpty()) {
            lines.add(SOURCE_SECTION);
            for (SourceLine line : sourceLines) {
                lines.add(PREFIX + line.getValue());
            }
        }
        return FFLines.create(lines);
    }
}

