/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.ffwriter.LineType;

public final class LineWrapperHelper {
    public static final int LINE_LENGTH = 75;
    public static final String SPACE = "   ";
    public static final String FEATURE_SPACE = "                                ";
    public static final String COMMENT_SPACE = "         ";

    public static StringBuilder wrap(StringBuilder wrapThis, LineType type, String spacing, String separator, String separator2, int wrapAt, String lineWrapWith, String endWith) {
        StringTokenizer st = new StringTokenizer(wrapThis.toString(), separator + separator2 + "\n", true);
        StringBuilder output = new StringBuilder();
        String startOfLine = (Object)((Object)type) + spacing;
        StringBuilder line = new StringBuilder();
        String lastToken = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                output.append(line.toString()).append(lineWrapWith);
                line = new StringBuilder(startOfLine);
            } else if (line.length() + token.length() <= wrapAt) {
                line.append(token);
            } else {
                String currentLine;
                if (token.equals(separator2)) {
                    line.delete(line.length() - lastToken.length(), line.length());
                    if (!lastToken.equals(" ")) {
                        token = lastToken + token;
                    }
                }
                if (!(currentLine = line.toString().trim()).equals(startOfLine.trim())) {
                    output.append(line.toString().trim()).append(lineWrapWith);
                    line = new StringBuilder(startOfLine);
                }
                if (!token.equals(separator)) {
                    line.append(token);
                }
            }
            lastToken = token;
        }
        output.append((CharSequence)line);
        output.append(endWith);
        return output;
    }

    public static StringBuilder wrapStringBuilder(StringBuilder inputRaw, Pattern delimiters, int lineLength, String lineStart, String tokenSeparator, String terminator) {
        String input = inputRaw + terminator;
        StringBuilder sRet = new StringBuilder();
        Matcher mat = delimiters.matcher(input);
        int currLineLength = sRet.length();
        int index = 0;
        boolean veryFirst = true;
        String token = "";
        int tokenLength = 0;
        while (mat.find()) {
            boolean firstInLine;
            token = input.substring(index, mat.end());
            tokenLength = token.length();
            if (currLineLength + LineWrapperHelper.removeTrailingWhiteSpace(new StringBuilder(token)).length() > lineLength) {
                LineWrapperHelper.removeTrailingWhiteSpace(sRet);
                sRet.append("\n" + lineStart);
                if (!input.substring(mat.start(), mat.end()).equals(" ")) {
                    token = token.trim();
                    tokenLength = token.length();
                }
                currLineLength = lineStart.length() + tokenLength;
                firstInLine = true;
            } else {
                firstInLine = false;
                currLineLength += tokenLength;
            }
            if (!firstInLine && !veryFirst) {
                sRet.append(tokenSeparator);
                currLineLength += tokenSeparator.length();
            }
            sRet.append(token);
            index = mat.end();
            veryFirst = false;
        }
        return sRet;
    }

    public static StringBuilder wrapWithPrecedence(StringBuilder curr, String[] chars, int length, String startLine) {
        StringBuilder toReturn = new StringBuilder();
        int indexLineStart = 0;
        int actualLineLength = length - startLine.length();
        int indexLineEnd = length;
        boolean first = true;
        while (indexLineEnd < curr.length()) {
            int newLinePos = LineWrapperHelper.lastIndexOfForString(curr, chars, indexLineEnd);
            toReturn.append(curr.subSequence(indexLineStart, newLinePos));
            toReturn.append("\n" + startLine);
            indexLineStart = newLinePos;
            if (first) {
                actualLineLength = length - startLine.length();
                first = false;
            }
            indexLineEnd = indexLineStart + actualLineLength;
        }
        toReturn.append(curr.subSequence(indexLineStart, curr.length()));
        return toReturn;
    }

    public static int lastIndexOfForString(StringBuilder in, String[] chars, int start) {
        int i;
        for (i = start; i >= 0; --i) {
            for (String against : chars) {
                try {
                    if (!against.equals(in.substring(i - against.length(), i))) continue;
                    return i;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return i;
    }

    public static StringBuilder removeTrailingWhiteSpace(StringBuilder in) {
        for (int i = in.length() - 1; i >= 0 && (in.charAt(i) == ' ' || in.charAt(i) == '\t'); --i) {
            in.deleteCharAt(i);
        }
        return in;
    }
}

