/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import uk.ac.ebi.kraken.ffwriter.UniprotFasta;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;

public class FastaWriter {
    public static String toFasta(UniRefEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(FastaWriter.toFastaHeader(entry)).append("\n").append(FastaWriter.toFastaBody(entry.getRepresentativeMember().getSequence().getValue()));
        return sb.toString();
    }

    public static String toFastaHeader(UniRefEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(">").append(entry.getUniRefEntryId().getValue());
        sb.append(" ");
        sb.append(entry.getRepresentativeMember().getProteinName().getValue());
        sb.append(" n=").append(entry.getMembers().size() + 1);
        String sourceOrganism = entry.getRepresentativeMember().getSourceOrganism().getValue();
        if (sourceOrganism.contains(" (")) {
            sourceOrganism = sourceOrganism.substring(0, sourceOrganism.indexOf(" (")).trim();
        }
        sb.append(" Tax=").append(sourceOrganism);
        sb.append(" TaxID=").append(entry.getRepresentativeMember().getNCBITaxonomy().getValue());
        sb.append(" RepID=").append(entry.getRepresentativeMember().getMemberId().getValue());
        return sb.toString();
    }

    public static String toFasta(UniParcEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(FastaWriter.toFastaHeader(entry)).append("\n").append(FastaWriter.toFastaBody(entry.getSequence().getValue()));
        return sb.toString();
    }

    public static String toFastaHeader(UniParcEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(">").append(entry.getUniParcId().getValue());
        return sb.toString();
    }

    public static String toFastaBody(String sequence) {
        StringBuilder sb = new StringBuilder();
        int columnCounter = 0;
        for (char c : sequence.toCharArray()) {
            sb.append(c);
            if (++columnCounter % 60 != 0 || columnCounter >= sequence.length()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toFasta(UniProtEntry entry) {
        UniprotFasta uniprotFasta = UniprotFasta.create(entry);
        return uniprotFasta.toString();
    }
}

