/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter;

import java.util.Date;
import java.util.Locale;
import uk.ac.ebi.kraken.ffwriter.line.impl.DTLineBuilder;
import uk.ac.ebi.kraken.interfaces.uniprot.EntryAudit;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.util.thread.SimpleDateFormatThreadSafe;

public class DTLine {
    private static final DTLineBuilder BUILDER = new DTLineBuilder();

    public static String export(UniProtEntry entry) {
        return BUILDER.build(entry).toString() + "\n";
    }

    public static String export(EntryAudit audit, boolean includeFlatFileMarkings) {
        return DTLine.export(audit, UniProtEntryType.UNKNOWN, includeFlatFileMarkings);
    }

    public static String export(EntryAudit audit, UniProtEntryType type, boolean includeFlatFileMarkings) {
        StringBuilder sb = new StringBuilder();
        Date cdate = audit.getFirstPublicDate();
        if (includeFlatFileMarkings) {
            sb.append("DT   ");
        }
        SimpleDateFormatThreadSafe formatter = new SimpleDateFormatThreadSafe("dd-MMM-yyyy", Locale.ENGLISH);
        String date = formatter.format(cdate.getTime()).toUpperCase();
        sb.append(date);
        switch (type) {
            case SWISSPROT: {
                sb.append(", integrated into UniProtKB/Swiss-Prot.\n");
                break;
            }
            case TREMBL: {
                sb.append(", integrated into UniProtKB/TrEMBL.\n");
                break;
            }
            case UNKNOWN: {
                sb.append(", integrated into UniProtKB.\n");
            }
        }
        int releaseNumber = audit.getSequenceVersion();
        cdate = audit.getLastSequenceUpdateDate();
        if (includeFlatFileMarkings) {
            sb.append("DT   ");
        }
        date = formatter.format(cdate.getTime()).toUpperCase();
        sb.append(date);
        sb.append(", sequence version ").append(releaseNumber).append(".\n");
        releaseNumber = audit.getEntryVersion();
        cdate = audit.getLastAnnotationUpdateDate();
        if (includeFlatFileMarkings) {
            sb.append("DT   ");
        }
        date = formatter.format(cdate.getTime());
        sb.append(date.toUpperCase());
        sb.append(", entry version ").append(releaseNumber).append(".\n");
        return sb.toString();
    }
}

